/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cvm;

import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.ocsp.BasicOCSPResp;
import cn.tca.TopBasicCrypto.ocsp.CertificateID;
import cn.tca.TopBasicCrypto.ocsp.OCSPReq;
import cn.tca.TopBasicCrypto.ocsp.OCSPReqGenerator;
import cn.tca.TopBasicCrypto.ocsp.OCSPResp;
import cn.tca.TopBasicCrypto.ocsp.RevokedStatus;
import cn.tca.TopBasicCrypto.ocsp.SingleResp;
import cn.tca.TopBasicCrypto.ocsp.UnknownStatus;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import com.itrus.cert.X509CRL;
import com.itrus.cert.X509Certificate;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cvm.CRLContext;
import com.itrus.cvm.CRLContextConfInfo;
import com.itrus.cvm.CVMConfigFactory;
import com.itrus.cvm.CertificateStatus;
import com.itrus.cvm.OCSPException;
import com.itrus.cvm.SimpleAuthenticator;
import com.itrus.util.CertUtils;
import com.itrus.util.FileUtils;
import com.itrus.util.RegexUtils;
import com.itrus.util.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVM
implements CertificateStatus {
    private static Log log = LogFactory.getLog((String)"ITRUS-CVM");
    private static Hashtable crlContexts = null;
    private static String DEFAULT_CONFIG_FILE_NAME = "cvm.xml";
    private static String configFileName = null;
    private static String OCSP_PROVIDER = "BC";

    public static void config(String fileName) {
        if (crlContexts != null) {
            log.debug((Object)("CVM\u5df2\u7ecf\u521d\u59cb\u5316\u3002" + configFileName));
        } else {
            configFileName = fileName;
            CVM.init();
        }
    }

    public static void reconfig(String fileName) {
        log.debug((Object)"\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\uff0c\u91cd\u65b0\u521d\u59cb\u5316CVM\u3002");
        Enumeration e = crlContexts.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            CRLContext cRLContext = (CRLContext)crlContexts.get(key);
            cRLContext.cancelTimingDownload();
        }
        crlContexts = null;
        CVM.config(fileName);
    }

    public static Hashtable getCRLContexts() {
        return crlContexts;
    }

    public static synchronized void clear() {
        if (crlContexts == null) {
            return;
        }
        crlContexts.clear();
    }

    public static synchronized void addSupportCA(String cAFileName, String cRLURL, String strRetryPolicy, boolean notCheckCRL, boolean timingDownload) throws CertificateException, NoSuchProviderException, IOException {
        boolean match = RegexUtils.matchesIgnoreCase(cAFileName, ".*(.cer|.crt|.pem)$");
        if (!match) {
            log.error((Object)"(addSupportCA)\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u540e\u7f00\u540d\u4e3a.cer\u6216\u8005.crt\u6216\u8005.pem\u7684\u8bc1\u4e66\u6587\u4ef6\u7684\u7edd\u5bf9\u8def\u5f84\uff01");
            return;
        }
        X509Certificate cACert = X509Certificate.getInstanceFromFile(cAFileName);
        if (crlContexts == null) {
            crlContexts = new Hashtable();
        }
        if (crlContexts.get(cACert.getSubjectDNString()) != null) {
            log.info((Object)("(addSupportCA)[" + cACert.getSubjectDNString() + "]\u5df2\u5b58\u5728\u3002"));
            return;
        }
        CRLContextConfInfo confInfo = new CRLContextConfInfo();
        String cRLFileName = RegexUtils.replaceLastIgnoreCase(cAFileName, ".cer|.crt|.pem", ".crl");
        confInfo.setCAFilePath(cAFileName);
        confInfo.setCRLFilePath(cRLFileName);
        confInfo.setCRLUrl(cRLURL);
        int[] retryPolicy = null;
        if (strRetryPolicy != null && !strRetryPolicy.equals("")) {
            String[] arrayRetryPolicy = strRetryPolicy.split(",");
            retryPolicy = new int[arrayRetryPolicy.length];
            for (int j = 0; j < arrayRetryPolicy.length; ++j) {
                retryPolicy[j] = Integer.parseInt(arrayRetryPolicy[j].trim());
            }
        }
        confInfo.setRetryPolicy(retryPolicy);
        confInfo.setNotCheckCRL(notCheckCRL);
        confInfo.setTimingDownload(timingDownload);
        CRLContext crlContext = new CRLContext(confInfo);
        crlContexts.put(crlContext.getCaCert().getSubjectDNString(), crlContext);
        log.debug((Object)("CVM.addSupportCA\uff0c\u589e\u52a0CA[" + crlContext.getCaCert().getSubjectDNString() + "]"));
    }

    public static synchronized void addSupportCA(String cAFileName, String cRLURL, String strRetryPolicy, boolean notCheckCRL) throws CertificateException, NoSuchProviderException, IOException {
        CVM.addSupportCA(cAFileName, cRLURL, strRetryPolicy, notCheckCRL, false);
    }

    public static synchronized void addSupportCA(X509Certificate cACert, java.security.cert.X509CRL crl, String cRLURL, String strRetryPolicy, boolean notCheckCRL, boolean timingDownload) throws IOException, CertificateException, NoSuchProviderException, CRLException {
        if (cACert == null) {
            throw new IOException("CACert is null");
        }
        if (crlContexts == null) {
            crlContexts = new Hashtable();
        }
        if (crlContexts.get(cACert.getSubjectDNString()) != null) {
            log.info((Object)("(addSupportCA)[" + cACert.getSubjectDNString() + "]\u5df2\u5b58\u5728\u3002"));
            return;
        }
        CRLContextConfInfo confInfo = new CRLContextConfInfo();
        String filePath = SystemUtils.getJavaIoTmpDir().getAbsolutePath();
        String cAFileName = filePath + SystemUtils.FILE_SEPARATOR + cACert.getCertID() + ".cer";
        String cRLFileName = filePath + SystemUtils.FILE_SEPARATOR + cACert.getCertID() + ".crl";
        if (!FileUtils.exists(cAFileName)) {
            FileUtils.saveBytesToFile(cACert.getEncoded(), cAFileName);
        }
        if (crl != null && !FileUtils.exists(cRLFileName)) {
            FileUtils.saveBytesToFile(crl.getEncoded(), cRLFileName);
        }
        confInfo.setCAFilePath(cAFileName);
        confInfo.setCRLFilePath(cRLFileName);
        confInfo.setCRLUrl(cRLURL);
        int[] retryPolicy = null;
        if (strRetryPolicy != null && !strRetryPolicy.equals("")) {
            String[] arrayRetryPolicy = strRetryPolicy.split(",");
            retryPolicy = new int[arrayRetryPolicy.length];
            for (int j = 0; j < arrayRetryPolicy.length; ++j) {
                retryPolicy[j] = Integer.parseInt(arrayRetryPolicy[j].trim());
            }
        }
        confInfo.setRetryPolicy(retryPolicy);
        confInfo.setNotCheckCRL(notCheckCRL);
        confInfo.setTimingDownload(timingDownload);
        CRLContext crlContext = new CRLContext(confInfo);
        crlContexts.put(crlContext.getCaCert().getSubjectDNString(), crlContext);
        log.debug((Object)("CVM.addSupportCA\uff0c\u589e\u52a0CA[" + crlContext.getCaCert().getSubjectDNString() + "]"));
    }

    public static synchronized void addSupportCA(X509Certificate cACert, java.security.cert.X509CRL crl, String cRLURL, String strRetryPolicy, boolean notCheckCRL) throws IOException, CertificateException, NoSuchProviderException, CRLException {
        CVM.addSupportCA(cACert, crl, cRLURL, strRetryPolicy, notCheckCRL, false);
    }

    public static synchronized void addSupportCA(X509Certificate cACert, String cRLURL, String strRetryPolicy, boolean notCheckCRL) throws IOException, CertificateException, NoSuchProviderException {
        try {
            CVM.addSupportCA(cACert, null, cRLURL, strRetryPolicy, notCheckCRL);
        }
        catch (CRLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static synchronized void removeSupportCA(X509Certificate cACert) {
        if (crlContexts == null) {
            return;
        }
        if (crlContexts.containsKey(cACert.getSubjectDNString())) {
            log.debug((Object)("(removeSupportCA)\u5220\u9664CA\u652f\u6301[" + cACert.getSubjectDNString() + "]"));
            crlContexts.remove(cACert.getSubjectDNString());
        }
    }

    public static synchronized void removeSupportCA(String cASubjectDNString) {
        if (crlContexts == null) {
            return;
        }
        if (crlContexts.containsKey(cASubjectDNString)) {
            log.debug((Object)("(removeSupportCA)\u5220\u9664CA\u652f\u6301[" + cASubjectDNString + "]"));
            crlContexts.remove(cASubjectDNString);
        }
    }

    public static String listCRLContexts() {
        StringBuffer str = new StringBuffer();
        if (crlContexts == null) {
            str.append("CVM\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6ca1\u6709\u652f\u6301\u7684CA\u3002");
        } else {
            Enumeration e = crlContexts.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                CRLContext cRLContext = (CRLContext)crlContexts.get(key);
                str.append("-----BEGIN CRLContext-----\r\n");
                str.append("SubjectDN=[" + key + "]\r\n");
                str.append("CaFileName=[" + cRLContext.getCAFilePath() + "]\r\n");
                str.append("CrlFileName=[" + cRLContext.getCrlFilePath() + "]\r\n");
                str.append("CRLExist=[" + (cRLContext.getX509CRL() != null) + "]\r\n");
                str.append("CrlUrl=[" + cRLContext.getCrlUrl() + "]\r\n");
                str.append("UserCrlUrl=[" + cRLContext.getUserCrlUrl() + "]\r\n");
                int[] retryPolicy = cRLContext.getRetryPolicy();
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < retryPolicy.length; ++i) {
                    if (i == 0) {
                        s.append(retryPolicy[i]);
                        continue;
                    }
                    s.append("," + retryPolicy[i]);
                }
                str.append("RetryPolicy=[" + s.toString() + "]\r\n");
                str.append("NotCheckCRL=[" + cRLContext.isNotCheckCRL() + "]\r\n");
                str.append("-----END CRLContext-----\r\n");
            }
        }
        return str.toString();
    }

    private static synchronized void init() {
        if (crlContexts == null) {
            try {
                CVMConfigFactory configFactory = new CVMConfigFactory();
                crlContexts = configFactory.getCRLContextHashtable(configFileName);
                log.debug((Object)"CVM\u521d\u59cb\u5316\u6210\u529f\u3002");
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static int verifyCertificate(java.security.cert.X509Certificate userCert) {
        if (crlContexts == null) {
            if (null == configFileName) {
                String configPath = CVM.class.getResource("/").getPath();
                configPath = configPath.replaceAll("%20", " ");
                int classesPos = configPath.indexOf("classes");
                configFileName = (classesPos < 0 ? configPath : configPath.substring(0, classesPos)) + DEFAULT_CONFIG_FILE_NAME;
                log.info((Object)("\u81ea\u52a8\u521d\u59cb\u5316\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6[" + configFileName + "]"));
            }
            CVM.init();
            if (null == crlContexts) {
                log.error((Object)"\u4e25\u91cd\u7cfb\u7edf\u9519\u8bef\uff0cCVM\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u548c\u65e5\u5fd7\u3002");
                return -1;
            }
        }
        X509Certificate cert = null;
        try {
            cert = X509Certificate.getInstance(userCert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CRLContext crlContext = null;
        log.debug((Object)("\u67e5\u627e\u652f\u6301\u7684CA[" + cert.getIssuerDNString() + "]"));
        crlContext = (CRLContext)crlContexts.get(cert.getIssuerDNString());
        if (null == crlContext) {
            log.info((Object)("\u4e0d\u652f\u6301\u7684\u9881\u53d1\u8005=[" + cert.getIssuerDNString() + "]\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
            return 3;
        }
        X509Certificate cACert = crlContext.getCaCert();
        if (!cert.verify(cACert)) {
            log.info((Object)("(" + crlContext.getCaAlias() + ")\u9a8c\u8bc1CA\u7b7e\u540d\u5931\u8d25\uff0c\u7591\u662f\u4f2a\u9020\u8bc1\u4e66\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
            return 4;
        }
        X509CRL x509CRL = crlContext.getX509CRL(cert.getCRLDistributionPointURL());
        if (x509CRL == null) {
            log.error((Object)("(" + crlContext.getCaAlias() + ")\u65e0\u6cd5\u83b7\u53d6CRL\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u548c\u7f51\u7edc\u3002"));
            return 5;
        }
        if (((CRL)x509CRL).isRevoked(cert)) {
            if (!CertUtils.isValid(cert)) {
                log.info((Object)("(" + crlContext.getCaAlias() + ")\u8bc1\u4e66\u5df2\u88ab\u540a\u9500\u800c\u4e14\u5df2\u8fc7\u671f\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
                return 6;
            }
            log.info((Object)("(" + crlContext.getCaAlias() + ")\u8bc1\u4e66\u5df2\u540a\u9500\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
            return 2;
        }
        if (!cert.isOnValidPeriod()) {
            log.info((Object)("(" + crlContext.getCaAlias() + ")\u8bc1\u4e66\u5df2\u8fc7\u671f\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
            return 1;
        }
        String accountHash = crlContext.getAccountHash();
        if (accountHash != null && !accountHash.equalsIgnoreCase(cert.getAccountHash())) {
            log.info((Object)("AccountHash\u4e0d\u5339\u914d\uff0cCert's AccountHash=[" + cert.getAccountHash() + "]\uff0cRA's AccountHash=[" + accountHash + "]\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
            return 8;
        }
        log.debug((Object)("(" + crlContext.getCaAlias() + ")\u8bc1\u4e66\u72b6\u6001\u6709\u6548\uff0cCert's SubjectDN=[" + cert.getSubjectDNString() + "]"));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int verifyCertificate(java.security.cert.X509Certificate userCert, java.security.cert.X509Certificate cACert, String ocspUrlStr) throws OCSPException, IOException, CryptoException {
        OCSPReq oCSPReq;
        Security.addProvider(new BouncyCastleProvider());
        try {
            userCert.verify(cACert.getPublicKey());
        }
        catch (InvalidKeyException e) {
            return 4;
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        if (!CertUtils.isOnValidPeriod(userCert)) {
            return 1;
        }
        try {
            CertificateID id = new CertificateID("1.3.14.3.2.26", cACert, userCert.getSerialNumber());
            OCSPReqGenerator oCSPReqGenerator = new OCSPReqGenerator();
            oCSPReqGenerator.addRequest(id);
            oCSPReq = oCSPReqGenerator.generate();
        }
        catch (cn.tca.TopBasicCrypto.ocsp.OCSPException e) {
            throw new OCSPException(e);
        }
        byte[] oCSPReqBuf = oCSPReq.getEncoded();
        HttpURLConnection httpURLConnection = null;
        try {
            log.debug((Object)("ocspUrlStr=" + ocspUrlStr));
            boolean bAuth = RegexUtils.matches(ocspUrlStr, "^http+s?://.*:.*@.*");
            String userName = null;
            String password = null;
            String authorization = null;
            if (bAuth) {
                userName = RegexUtils.exceptMatches(ocspUrlStr, "^http+s?://+|:.*@.*$");
                password = RegexUtils.exceptMatches(ocspUrlStr, "^http+s?://.*:+|@[^@]*$");
                ocspUrlStr = RegexUtils.exceptMatches(ocspUrlStr, userName + ":" + password + "@");
                authorization = "Basic " + new String(Base64.encode((userName + ":" + password).getBytes()));
                Authenticator.setDefault(new SimpleAuthenticator(userName, password));
                log.debug((Object)("userName=" + userName + ", password=" + password + ", ocspUrlStr=" + ocspUrlStr + ", BASE64 Authorization=" + authorization));
            }
            URL url = new URL(ocspUrlStr);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Accept", "application/ocsp-response");
            if (bAuth) {
                httpURLConnection.setRequestProperty("Authorization", authorization);
            }
            httpURLConnection.setDoOutput(true);
            OutputStream out = httpURLConnection.getOutputStream();
            DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(oCSPReqBuf);
            dataOut.flush();
            dataOut.close();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode / 100 != 2) {
                throw new IOException("Http status not ok, code=" + responseCode);
            }
            InputStream in = httpURLConnection.getInputStream();
            OCSPResp ocspResponse = new OCSPResp(in);
            if (ocspResponse.getStatus() != 0) {
                String str = "";
                switch (ocspResponse.getStatus()) {
                    case 1: {
                        str = "Illegal confirmation request";
                        break;
                    }
                    case 2: {
                        str = "Internal error in issuer";
                        break;
                    }
                    case 3: {
                        str = "Try again later";
                        break;
                    }
                    case 4: {
                        str = "(4) not used";
                        break;
                    }
                    case 5: {
                        str = "Must sign the request";
                        break;
                    }
                    case 6: {
                        str = "Request unauthorized";
                    }
                }
                OCSPException e = new OCSPException("Response status(" + ocspResponse.getStatus() + ") not zero. The reason is \"" + str + "\".");
                e.setOCSPResponseStatus(ocspResponse.getStatus());
                throw e;
            }
            BasicOCSPResp basicOCSPResp = null;
            try {
                basicOCSPResp = (BasicOCSPResp)ocspResponse.getResponseObject();
                java.security.cert.X509Certificate[] chain = new X509Certificate[1];
                chain = basicOCSPResp.getCerts(OCSP_PROVIDER);
                if (!basicOCSPResp.verify(chain[0].getPublicKey(), OCSP_PROVIDER)) {
                    throw new OCSPException("failed to verify OCSP Signature.");
                }
            }
            catch (cn.tca.TopBasicCrypto.ocsp.OCSPException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchProviderException e) {
                throw new CryptoException(e);
            }
            SingleResp[] singleResps = basicOCSPResp.getResponses();
            log.debug((Object)("basicOCSPResp.getProducedAt()=" + basicOCSPResp.getProducedAt().toLocaleString()));
            log.debug((Object)("singleResps[0].getThisUpdate()=" + singleResps[0].getThisUpdate().toLocaleString()));
            log.debug((Object)("singleResps[0].getNextUpdate()=" + singleResps[0].getNextUpdate().toLocaleString()));
            if (singleResps[0].getCertStatus() == null) {
                int n = 0;
                return n;
            }
            Object o = singleResps[0].getCertStatus();
            if (o instanceof RevokedStatus) {
                RevokedStatus revokedStatus = (RevokedStatus)o;
                log.debug((Object)("revocationTime=" + revokedStatus.getRevocationTime().toLocaleString()));
                log.debug((Object)("revocationReason=" + revokedStatus.getRevocationReason()));
                int n = 2;
                return n;
            }
            if (o instanceof UnknownStatus) {
                UnknownStatus unknownStatus = (UnknownStatus)o;
                System.out.println("UnknownStatus\uff1a" + unknownStatus.toString());
                int n = 7;
                return n;
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
        return 7;
    }

    public static CRLContext getCRLContext(String issuerDN) {
        CRLContext crlContext = (CRLContext)crlContexts.get(issuerDN);
        return crlContext;
    }
}

