/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.pki.rsa;

import cn.topca.security.pkcs11.jna.PKCS11Exception;
import com.itrus.base.service.ClientSignService;
import com.itrus.util.DataUtil;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class iTrusUsbKey {
    private static final Logger log = Logger.getLogger(iTrusUsbKey.class);
    private ClientSignService cs = null;

    public iTrusUsbKey() {
        log.info((Object)">>iTrusUsbKey()");
        this.cs = new ClientSignService();
    }

    public iTrusUsbKey(String path) {
        log.info((Object)(">>iTrusUsbKey(" + path + ")"));
        this.cs = new ClientSignService(path);
    }

    public String isUsbKeyExistent() {
        log.info((Object)">>isUsbKeyExistent()");
        if (this.cs == null) {
            log.error((Object)"ClientSignService init fail");
            return null;
        }
        return this.cs.isUsbKeyExist();
    }

    public boolean checkPasswd(byte[] password) {
        log.info((Object)">>checkPasswd(..)");
        log.info((Object)("password hex:[" + DataUtil.transformByteArrayToHexString(password) + "]"));
        if (this.isUsbKeyExistent() == null) {
            log.error((Object)"not find USBkey");
            return false;
        }
        char[] pin = new char[password.length];
        int i = 0;
        while (i < pin.length) {
            pin[i] = (char)password[i];
            ++i;
        }
        return this.cs.loginUsbkey(pin);
    }

    public byte[] exportCertificate() {
        log.info((Object)">>exportCertificate()");
        try {
            return this.cs.getCert().getEncoded();
        }
        catch (CertificateEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"exportCertificate() return null!");
        return null;
    }

    public byte[] getUserID() {
        log.info((Object)">>getUserID()");
        try {
            return this.cs.getUserIdentifier().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public byte[] sign(byte[] plaintext) {
        log.info((Object)">>sign()");
        try {
            byte[] bytes = this.cs.sign(plaintext);
            return bytes;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.error((Object)"sign(plaintext) return null!");
            return null;
        }
    }

    public boolean hasLoginOn() {
        log.info((Object)">>hasLoginOn()");
        return this.cs.hasLoginOn();
    }

    public String GetKeyID() {
        log.info((Object)">>GetKeyID()");
        return this.cs.getCertSN();
    }

    public int verify(byte[] plaintext, byte[] signature) {
        log.info((Object)(">>verify(plaintext[HEX:" + DataUtil.transformByteArrayToHexString(plaintext) + "],signature[HEX:" + DataUtil.transformByteArrayToHexString(signature) + "]"));
        X509Certificate cert = null;
        try {
            cert = this.cs.getCert();
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.cs.verifySignature(plaintext, signature, cert);
    }
}

