/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.util;

import com.itrus.security.util.DerInputBuffer;
import com.itrus.security.util.DerInputStream;
import com.itrus.security.util.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private static final int maxFirstComponent = 2;
    private static final int maxSecondComponent = 39;
    private int[] components;
    private int componentLen;
    private volatile transient String stringForm;
    private static final int allocationQuantum = 5;

    public ObjectIdentifier(String oid) throws IOException {
        int ch = 46;
        int start = 0;
        int end = 0;
        this.componentLen = 0;
        while ((end = oid.indexOf(ch, start)) != -1) {
            start = end + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        start = 0;
        int i = 0;
        String comp = null;
        try {
            while ((end = oid.indexOf(ch, start)) != -1) {
                comp = oid.substring(start, end);
                this.components[i++] = Integer.valueOf(comp);
                start = end + 1;
            }
            comp = oid.substring(start);
            this.components[i] = Integer.valueOf(comp);
        }
        catch (Exception e) {
            throw new IOException("ObjectIdentifier() -- Invalid format: " + e.toString());
        }
        this.checkValidOid(this.components, this.componentLen);
        this.stringForm = oid;
    }

    private void checkValidOid(int[] values, int len) throws IOException {
        if (values == null || len < 2) {
            throw new IOException("ObjectIdentifier() -- Must be at least two oid components ");
        }
        int i = 0;
        while (i < len) {
            if (values[i] < 0) {
                throw new IOException("ObjectIdentifier() -- oid component #" + (i + 1) + " must be non-negative ");
            }
            ++i;
        }
        if (values[0] > 2) {
            throw new IOException("ObjectIdentifier() -- First oid component is invalid ");
        }
        if (values[0] < 2 && values[1] > 39) {
            throw new IOException("ObjectIdentifier() -- Second oid component is invalid ");
        }
    }

    public ObjectIdentifier(int[] values) throws IOException {
        this.checkValidOid(values, values.length);
        this.components = (int[])values.clone();
        this.componentLen = values.length;
    }

    public ObjectIdentifier(DerInputStream in) throws IOException {
        byte type_id = (byte)in.getByte();
        if (type_id != 6) {
            throw new IOException("ObjectIdentifier() -- data isn't an object ID (tag = " + type_id + ")");
        }
        int bufferEnd = in.available() - in.getLength() - 1;
        if (bufferEnd < 0) {
            throw new IOException("ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(in, bufferEnd);
    }

    ObjectIdentifier(DerInputBuffer buf) throws IOException {
        this.initFromEncoding(new DerInputStream(buf), 0);
    }

    private ObjectIdentifier(int[] components, boolean dummy) {
        this.components = components;
        this.componentLen = components.length;
    }

    public static ObjectIdentifier newInternal(int[] values) {
        return new ObjectIdentifier(values, true);
    }

    private void initFromEncoding(DerInputStream in, int bufferEnd) throws IOException {
        boolean first_subid = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (in.available() > bufferEnd) {
            int component = ObjectIdentifier.getComponent(in);
            if (component < 0) {
                throw new IOException("ObjectIdentifier() -- component values must be nonnegative");
            }
            if (first_subid) {
                int X = component < 40 ? 0 : (component < 80 ? 1 : 2);
                int Y = component - X * 40;
                this.components[0] = X;
                this.components[1] = Y;
                this.componentLen = 2;
                first_subid = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] tmp_components = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, tmp_components, 0, this.components.length);
                this.components = tmp_components;
            }
            this.components[this.componentLen++] = component;
        }
        this.checkValidOid(this.components, this.componentLen);
        if (in.available() != bufferEnd) {
            throw new IOException("ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        if (this.components[0] < 2) {
            bytes.write(this.components[0] * 40 + this.components[1]);
        } else {
            ObjectIdentifier.putComponent(bytes, this.components[0] * 40 + this.components[1]);
        }
        int i = 2;
        while (i < this.componentLen) {
            ObjectIdentifier.putComponent(bytes, this.components[i]);
            ++i;
        }
        out.write((byte)6, bytes);
    }

    private static int getComponent(DerInputStream in) throws IOException {
        int i = 0;
        int retval = 0;
        while (i < 4) {
            retval <<= 7;
            int tmp = in.getByte();
            if (i == 0 && tmp == 128) {
                throw new IOException("ObjectIdentifier() -- sub component starts with 0x80");
            }
            retval |= tmp & 0x7F;
            if ((tmp & 0x80) == 0) {
                return retval;
            }
            ++i;
        }
        throw new IOException("ObjectIdentifier() -- component value too big");
    }

    private static void putComponent(DerOutputStream out, int val) throws IOException {
        byte[] buf = new byte[4];
        int i = 0;
        while (i < 4) {
            buf[i] = (byte)(val & 0x7F);
            if ((val >>>= 7) == 0) break;
            ++i;
        }
        while (i > 0) {
            out.write(buf[i] | 0x80);
            --i;
        }
        out.write(buf[0]);
    }

    public boolean precedes(ObjectIdentifier other) {
        if (other == this || this.componentLen < other.componentLen) {
            return false;
        }
        if (other.componentLen < this.componentLen) {
            return true;
        }
        int i = 0;
        while (i < this.componentLen) {
            if (other.components[i] < this.components[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Deprecated
    public boolean equals(ObjectIdentifier other) {
        return this.equals((Object)other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier other = (ObjectIdentifier)obj;
        if (this.componentLen != other.componentLen) {
            return false;
        }
        int i = 0;
        while (i < this.componentLen) {
            if (this.components[i] != other.components[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = this.componentLen;
        int i = 0;
        while (i < this.componentLen) {
            h += this.components[i] * 37;
            ++i;
        }
        return h;
    }

    public String toString() {
        String s = this.stringForm;
        if (s == null) {
            StringBuffer sb = new StringBuffer(this.componentLen * 4);
            int i = 0;
            while (i < this.componentLen) {
                if (i != 0) {
                    sb.append('.');
                }
                sb.append(this.components[i]);
                ++i;
            }
            this.stringForm = s = sb.toString();
        }
        return s;
    }
}

