/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.test;

import com.itrus.obm.iTrusObm;
import com.itrus.pki.rsa.iTrusRSAAPI;
import com.itrus.pki.rsa.iTrusUsbKey;
import com.itrus.pki.rsa.server.iTrusServerSignVerify;
import com.itrus.util.Base64c;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class EASTest {
    private byte[] pin = "12345678".getBytes();
    private String plaintext = "12345678";
    int n = 1;

    @Before
    public void beforeTest() {
        PropertyConfigurator.configure((String)"C:\\Users\\Itrus_ruihai.Shen\\Desktop\\project\\change\\iTrus-kingdee-eas-20150610\\server\\properties\\itrusservercfg\\serverlog4j.properties");
        System.setProperty("easclient.root", "C:\\Users\\Itrus_ruihai.Shen\\Desktop\\project\\change\\iTrus-kingdee-eas-20150610");
        System.setProperty("EAS_HOME", "C:\\Users\\Itrus_ruihai.Shen\\Desktop\\project\\change\\iTrus-kingdee-eas-20150610");
    }

    @Test
    public void testServerSign() {
        try {
            byte[] bytes = Base64c.decode("_aa@a--*-1;23");
            System.out.println(new String(bytes));
        }
        catch (Exception e) {
            System.out.println("aa1;23");
            e.printStackTrace();
        }
        try {
            Base64c.decode("\u4e2d\u6587");
        }
        catch (Exception e) {
            System.out.println("\u4e2d\u6587");
            e.printStackTrace();
        }
        Base64c.decode("aaa123");
        iTrusServerSignVerify issv = new iTrusServerSignVerify();
        byte[] signature = issv.sign("1234".getBytes());
        System.out.println(issv.verify("1234".getBytes(), signature));
    }

    public void test() throws Exception {
        iTrusUsbKey uk = new iTrusUsbKey();
        System.out.println(uk.isUsbKeyExistent());
        System.out.println(uk.checkPasswd(this.pin));
        byte[] certByte = uk.exportCertificate();
        String signature = Base64c.encode(uk.sign(this.plaintext.getBytes()));
        System.out.println(signature);
        iTrusRSAAPI serv = new iTrusRSAAPI();
        X509Certificate cert = serv.getX509CertificateFormBytes(certByte);
        int i = 0;
        while (i < 100) {
            long t1 = System.currentTimeMillis();
            int falg = serv.verifyCert(cert);
            int flag = serv.verify(this.plaintext.getBytes(), Base64c.decode(signature), cert);
            long t2 = System.currentTimeMillis();
            System.out.println(String.valueOf(falg) + "    " + flag + "    " + (t2 - t1));
            ++i;
        }
    }

    @Test
    public void testEASClient() throws Exception {
        int i = 0;
        while (i < this.n) {
            iTrusUsbKey uk = new iTrusUsbKey();
            String ret = null;
            boolean ret2 = false;
            byte[] uid = new byte[]{};
            String serialNumber = "";
            byte[] certbuf = new byte[]{};
            byte[] signature = new byte[]{};
            ret = uk.isUsbKeyExistent();
            System.out.println("isUsbKeyExistent:[" + ret + "]");
            if (ret != null) {
                uid = uk.getUserID();
                System.out.println("uid[" + new String(uid) + "]");
                serialNumber = uk.GetKeyID();
                System.out.println("serialNumber[" + serialNumber + "]");
                certbuf = uk.exportCertificate();
                System.out.println("certbuf[" + Base64c.encode(certbuf) + "]");
                ret2 = uk.checkPasswd(this.pin);
                System.out.println("checkPasswd:[" + ret2 + "]");
                if (ret2) {
                    signature = uk.sign(this.plaintext.getBytes());
                    System.out.println("signature lenth:[" + signature.length + "]");
                    System.out.println("signature:[" + Base64c.encode(signature) + "]");
                } else {
                    System.out.println("pin error ");
                    return;
                }
            }
            iTrusRSAAPI server = new iTrusRSAAPI();
            int vret2 = server.verify(this.plaintext.getBytes(), signature, this.getCertFromB64(certbuf));
            System.out.println("verify:" + (vret2 == 201));
            ++i;
        }
    }

    private X509Certificate getCertFromB64(String certBase64) throws CertificateException, NoSuchProviderException {
        byte[] decode = Base64c.decode(certBase64);
        X509Certificate certFromB64 = this.getCertFromB64(decode);
        return certFromB64;
    }

    private X509Certificate getCertFromB64(byte[] certBuf) throws CertificateException, NoSuchProviderException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBuf));
        return certificate;
    }

    @Ignore
    @Test
    public void testObm() throws Exception {
        String plaintext = "<?xml#version=\"1.0\"#encoding=\"GB2312\"?><data#bank=\"tokenbank\"#dealtype=\"online\"#filetype=\"xml\"#func=\"token\"#roottag=\"input\"#type=\"\"#version=\"nctoken\"><row#newpackageid=\"130425092024008\"></row></data>";
        iTrusObm obm = new iTrusObm();
        try {
            String signature = obm.sign(plaintext);
            boolean result = obm.verify(plaintext, signature);
            System.out.println("Verify:" + (result ? "OK" : "Fail"));
            System.out.println("plaintext:" + plaintext);
            System.out.println("signature:" + signature);
            String cryStr = obm.encode(plaintext);
            System.out.println("\u52a0\u5bc6\u7ed3\u679c\uff1a" + cryStr);
            String dcryStr = obm.decode(cryStr);
            System.out.println("\u89e3\u5bc6\u6210\u529f" + dcryStr);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

