/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.util.Base64c;
import com.itrus.util.NoMatchingException;
import com.itrus.util.PKIUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CertificateUtil {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";

    public static CRL getCRL(String crlUrl) throws CertificateException, CRLException, IOException {
        URL crlURL = null;
        try {
            crlURL = new URL(crlUrl);
        }
        catch (MalformedURLException e) {
            String message = e.getMessage();
            if (message.indexOf("unknown protocol") >= 0) {
                crlURL = new URL("File:///".concat(crlUrl));
            }
            throw e;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509CRL crl = (X509CRL)cf.generateCRL(crlURL.openConnection().getInputStream());
        return crl;
    }

    public static String matchSubject(Certificate certificate, String regex, int groupIndex) throws NoMatchingException {
        X509Certificate x509cert = (X509Certificate)certificate;
        Pattern p = Pattern.compile(regex);
        Matcher match = p.matcher(x509cert.getSubjectDN().getName());
        if (match.find()) {
            return match.group(groupIndex);
        }
        throw new NoMatchingException("No matching from the certificate. @SerialNumber: ".concat(x509cert.getSerialNumber().toString(16)));
    }

    public static Certificate conertCertificate(String certificatePEMBuffer) throws CertificateException, IOException {
        if (certificatePEMBuffer.contains(BEGIN_CERT)) {
            certificatePEMBuffer = certificatePEMBuffer.substring(BEGIN_CERT.length(), certificatePEMBuffer.indexOf(END_CERT));
        }
        certificatePEMBuffer = certificatePEMBuffer.replaceAll("\\s", "");
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64c.decode(certificatePEMBuffer));
        return PKIUtil.conertCert(bais);
    }

    public static Certificate conertCertificate(File certFile) throws CertificateException, IOException {
        return PKIUtil.conertCert(new FileInputStream(certFile));
    }

    public static Certificate conertCertificate(byte[] derBuf) throws CertificateException, IOException {
        return PKIUtil.conertCert(new ByteArrayInputStream(derBuf));
    }

    public static BigInteger conertCertSerialnumber(String serialnumber) {
        return new BigInteger(serialnumber.replaceAll("[^0-9|^a-f|^A-F]", ""), 16);
    }
}

