/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.util.CryptoException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;

public class KeyStoreType {
    public static final KeyStoreType JCEKS = new KeyStoreType("JCEKS", true, false, new String[]{"jceks"});
    public static final KeyStoreType JKS = new KeyStoreType("JKS", true, false, new String[]{"jks"});
    public static final KeyStoreType PKCS11 = new KeyStoreType("PKCS11", false, false, new String[0]);
    public static final KeyStoreType PKCS12 = new KeyStoreType("PKCS12", false, true, new String[]{"p12", "pfx"});
    public static final KeyStoreType BKS = new KeyStoreType("BKS", true, true, new String[]{"bks"});
    public static final KeyStoreType UBER = new KeyStoreType("UBER", true, true, new String[]{"ubr"});
    public static final KeyStoreType GKR = new KeyStoreType("GKR", true, true, new String[]{"gkr"});
    private static final LinkedHashMap TYPE_MAP = new LinkedHashMap();
    private static ResourceBundle m_res;
    private final String m_sType;
    private final boolean m_bCreationDate;
    private final boolean m_bCaseSensitive;
    private final String[] m_exts;

    public KeyStoreType(String sType, boolean bCreationDate, boolean bCaseSensitive, String[] exts) {
        this.m_sType = sType;
        this.m_bCreationDate = bCreationDate;
        this.m_bCaseSensitive = bCaseSensitive;
        this.m_exts = exts;
    }

    public static KeyStoreType getInstance(String sType) throws CryptoException {
        KeyStoreType kst = (KeyStoreType)TYPE_MAP.get(sType);
        if (kst == null) {
            throw new CryptoException(MessageFormat.format(m_res.getString("NoResolveKeystoretype.exception.message"), sType));
        }
        return kst;
    }

    public static KeyStoreType[] getKnownTypes() {
        return TYPE_MAP.values().toArray(new KeyStoreType[TYPE_MAP.size()]);
    }

    public boolean supportsCreationDate() {
        return this.m_bCreationDate;
    }

    public boolean isCaseSensitive() {
        return this.m_bCaseSensitive;
    }

    public String[] getFilenameExtensions() {
        String[] exts = new String[this.m_exts.length];
        System.arraycopy(this.m_exts, 0, exts, 0, exts.length);
        return exts;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return KeyStoreType.getInstance(this.m_sType);
        }
        catch (CryptoException e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        return this.m_sType;
    }

    public String toPrettyString() {
        if (this.equals(PKCS11)) {
            return "PKCS #11";
        }
        if (this.equals(PKCS12)) {
            return "PKCS #12";
        }
        return this.toString();
    }

    static {
        TYPE_MAP.put(JKS.toString(), JKS);
        TYPE_MAP.put(PKCS12.toString(), PKCS12);
        TYPE_MAP.put(JCEKS.toString(), JCEKS);
        TYPE_MAP.put(BKS.toString(), BKS);
        TYPE_MAP.put(UBER.toString(), UBER);
        TYPE_MAP.put(GKR.toString(), GKR);
        TYPE_MAP.put(PKCS11.toString(), PKCS11);
        m_res = ResourceBundle.getBundle("sun.security.util.Resources");
    }
}

