/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.util.Base64c;
import com.itrus.util.DataUtil;
import com.itrus.util.NetworkInfo;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class MaskPasswordUtils {
    private static final String KEY_ALGORITHM = "DES";
    private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    private static final byte[] keyBytes = MaskPasswordUtils.getMachineCharacterCode();
    private static final byte[] iv = new byte[]{48, 48, 48, 48, 48, 48, 48, 48};

    public static byte[] encrypt(byte[] src) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec deskey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)deskey, ivSpec);
        return cipher.doFinal(src);
    }

    public static byte[] decrypt(byte[] src) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec deskey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)deskey, ivSpec);
        return cipher.doFinal(src);
    }

    public static byte[] getMachineCharacterCode() {
        byte[] tmpkeyBytes = new byte[]{48, 48, 48, 48, 48, 48, 48, 48};
        byte[] machineCharaterCodeBuf = null;
        try {
            machineCharaterCodeBuf = DataUtil.transformHexStringToByteArray(NetworkInfo.getMacAddress());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int length = machineCharaterCodeBuf.length < tmpkeyBytes.length ? machineCharaterCodeBuf.length : tmpkeyBytes.length;
        System.arraycopy(machineCharaterCodeBuf, 0, tmpkeyBytes, 0, length);
        return tmpkeyBytes;
    }

    public static String encrypt(String Source2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] encoded = MaskPasswordUtils.encrypt(Source2.getBytes());
        String strBase64 = new String(Base64c.encode(encoded));
        return strBase64;
    }

    public static String decrypt(String Source2) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] src = Base64c.decode(Source2);
        byte[] srcBytes = MaskPasswordUtils.decrypt(src);
        String str = new String(srcBytes);
        return str;
    }

    public static String getMachineCodePass() throws Exception {
        return MaskPasswordUtils.encrypt(NetworkInfo.getMacAddress());
    }
}

