/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        return doc;
    }

    public static Document createDocumentFromXML(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = builder.parse(in);
        return doc;
    }

    public static Document createDocumentFromXMLFile(String uri) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(uri);
        return doc;
    }

    public static Element createRootNode(Document doc, String rootNodeName) {
        Element root = doc.createElement(rootNodeName);
        doc.appendChild(root);
        return root;
    }

    public static void appendAttribute(Document doc, Element baseElement, String attrName, String attrValue) {
        Attr attr = doc.createAttribute(attrName);
        attr.setNodeValue(attrValue);
        baseElement.setAttributeNode(attr);
    }

    public static Element appendNode(Document doc, Element baseElement, String nodeName) {
        Element node = doc.createElement(nodeName);
        baseElement.appendChild(node);
        return node;
    }

    public static Element appendMixedNode(Document doc, Element baseElement, String nodeName, String nodeValue) {
        Element childNode = doc.createElement(nodeName);
        childNode.appendChild(doc.createTextNode(nodeValue));
        baseElement.appendChild(childNode);
        return childNode;
    }

    public static String transformToXML(Document doc, String encoding) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        DOMSource dom = new DOMSource(doc);
        t.setOutputProperty("encoding", encoding);
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        t.transform(dom, sr);
        return sw.getBuffer().toString();
    }
}

