/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;
import org.jbarcode.paint.BarcodePainter;
import org.jbarcode.paint.TextPainter;

public class JBarcodeComponent
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JBarcode jbarcode;
    private BufferedImage img;
    private String text;
    private String checkSum;

    public JBarcodeComponent(JBarcode jBarcode) {
        this(jBarcode, "");
    }

    public JBarcodeComponent(JBarcode jBarcode, String string) {
        this.jbarcode = jBarcode;
        this.addPropertyChangeListener(this);
        if (string != null) {
            try {
                this.setText(string);
            }
            catch (InvalidAtributeException invalidAtributeException) {
                // empty catch block
            }
        }
        this.setBackground(Color.white);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.img != null) {
            int n = (this.getWidth() - this.img.getWidth()) / 2;
            int n2 = (this.getHeight() - this.img.getHeight()) / 2;
            graphics.drawImage(this.img, n, n2, this);
        }
        super.paint(graphics);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) throws InvalidAtributeException {
        if (string.equals(this.getText())) {
            return;
        }
        String string2 = this.text;
        this.text = string;
        this.checkSum = this.jbarcode.calcCheckSum(string);
        this.firePropertyChange("Text", string2, string);
        this.invalidate();
        this.repaint();
    }

    public double getBarHeight() {
        return this.jbarcode.getBarHeight();
    }

    public BarcodeEncoder getEncoder() {
        return this.jbarcode.getEncoder();
    }

    public double getXDimension() {
        return this.jbarcode.getXDimension();
    }

    public BarcodePainter getPainter() {
        return this.jbarcode.getPainter();
    }

    public double getWideRatio() {
        return this.jbarcode.getWideRatio();
    }

    public void setBarHeight(double d) {
        if (this.getBarHeight() == d) {
            return;
        }
        double d2 = this.getBarHeight();
        this.jbarcode.setBarHeight(d);
        this.firePropertyChange("BarHeigth", d2, d);
        this.invalidate();
        this.repaint();
    }

    public void setEncoder(BarcodeEncoder barcodeEncoder) {
        if (this.getEncoder().equals(barcodeEncoder)) {
            return;
        }
        BarcodeEncoder barcodeEncoder2 = this.getEncoder();
        this.jbarcode.setEncoder(barcodeEncoder);
        this.firePropertyChange("Encoder", barcodeEncoder2, barcodeEncoder);
        this.invalidate();
        this.repaint();
    }

    public void setXDimension(double d) throws InvalidAtributeException {
        if (this.getXDimension() == d) {
            return;
        }
        double d2 = this.getXDimension();
        this.jbarcode.setXDimension(d);
        this.firePropertyChange("xDimension", d2, d);
        this.invalidate();
        this.repaint();
    }

    public void setPainter(BarcodePainter barcodePainter) {
        if (this.getPainter().equals(barcodePainter)) {
            return;
        }
        BarcodePainter barcodePainter2 = this.getPainter();
        this.jbarcode.setPainter(barcodePainter);
        this.firePropertyChange("Painter", barcodePainter2, barcodePainter);
        this.invalidate();
        this.repaint();
    }

    public void setWideRatio(double d) throws InvalidAtributeException {
        if (this.getWideRatio() == d) {
            return;
        }
        double d2 = this.getWideRatio();
        this.jbarcode.setWideRatio(d);
        this.firePropertyChange("wideRatio", d2, d);
        this.invalidate();
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.text != null && !"".equals(this.text) && this.jbarcode != null) {
                this.img = this.jbarcode.createBarcode(this.text);
            }
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(String string) {
        this.firePropertyChange("checkSum", this.checkSum, this.checkSum);
        this.invalidate();
        this.repaint();
    }

    public TextPainter getTextPainter() {
        return this.jbarcode.getTextPainter();
    }

    public boolean isCheckDigit() {
        return this.jbarcode.isCheckDigit();
    }

    public boolean isShowCheckDigit() {
        return this.jbarcode.isShowCheckDigit();
    }

    public boolean isShowText() {
        return this.jbarcode.isShowText();
    }

    public void setCheckDigit(boolean bl) {
        if (bl == this.isCheckDigit()) {
            return;
        }
        boolean bl2 = this.isCheckDigit();
        this.jbarcode.setCheckDigit(bl);
        this.firePropertyChange("checkDigit", bl2, bl);
        this.invalidate();
        this.repaint();
    }

    public void setShowCheckDigit(boolean bl) {
        if (bl == this.isShowCheckDigit()) {
            return;
        }
        boolean bl2 = this.isShowCheckDigit();
        this.jbarcode.setShowCheckDigit(bl);
        this.firePropertyChange("showCheckDigit", bl2, bl);
        this.invalidate();
        this.repaint();
    }

    public void setShowText(boolean bl) {
        if (bl == this.isShowText()) {
            return;
        }
        boolean bl2 = this.isShowText();
        this.jbarcode.setShowText(bl);
        this.firePropertyChange("showText", bl2, bl);
        this.invalidate();
        this.repaint();
    }

    public void setTextPainter(TextPainter textPainter) {
        if (this.getTextPainter().equals(textPainter)) {
            return;
        }
        TextPainter textPainter2 = this.getTextPainter();
        this.jbarcode.setTextPainter(textPainter);
        this.firePropertyChange("textPainter", textPainter2, textPainter);
        this.invalidate();
        this.repaint();
        this.jbarcode.setTextPainter(textPainter);
    }
}

