/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode;

import org.jbarcode.JBarcode;
import org.jbarcode.encode.CodabarEncoder;
import org.jbarcode.encode.Code11Encoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.Code39ExtEncoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.Code93ExtEncoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.encode.EAN8Encoder;
import org.jbarcode.encode.Interleaved2of5Encoder;
import org.jbarcode.encode.InvalidAtributeException;
import org.jbarcode.encode.MSIPlesseyEncoder;
import org.jbarcode.encode.PostNetEncoder;
import org.jbarcode.encode.Standard2of5Encoder;
import org.jbarcode.encode.UPCAEncoder;
import org.jbarcode.encode.UPCEEncoder;
import org.jbarcode.paint.BaseLineTextPainter;
import org.jbarcode.paint.EAN13TextPainter;
import org.jbarcode.paint.EAN8TextPainter;
import org.jbarcode.paint.HeightCodedPainter;
import org.jbarcode.paint.UPCATextPainter;
import org.jbarcode.paint.UPCETextPainter;
import org.jbarcode.paint.WideRatioCodedPainter;
import org.jbarcode.paint.WidthCodedPainter;

public class JBarcodeFactory {
    private static JBarcodeFactory instance;

    private JBarcodeFactory() {
    }

    public static JBarcodeFactory getInstance() {
        if (instance == null) {
            instance = new JBarcodeFactory();
        }
        return instance;
    }

    public JBarcode createEAN13() {
        JBarcode jBarcode = new JBarcode(EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(true);
        return jBarcode;
    }

    public JBarcode createEAN8() {
        JBarcode jBarcode = new JBarcode(EAN8Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN8TextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(true);
        return jBarcode;
    }

    public JBarcode createUPCA() {
        JBarcode jBarcode = new JBarcode(UPCAEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCATextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(true);
        return jBarcode;
    }

    public JBarcode createUPCE() {
        JBarcode jBarcode = new JBarcode(UPCEEncoder.getInstance(), WidthCodedPainter.getInstance(), UPCETextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(true);
        return jBarcode;
    }

    public JBarcode createCodabar() {
        JBarcode jBarcode = new JBarcode(CodabarEncoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(false);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createCode11() {
        JBarcode jBarcode = new JBarcode(Code11Encoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(true);
        return jBarcode;
    }

    public JBarcode createCode39() {
        JBarcode jBarcode = new JBarcode(Code39Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(false);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createCode39Extended() {
        JBarcode jBarcode = new JBarcode(Code39ExtEncoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(false);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createCode93() {
        JBarcode jBarcode = new JBarcode(Code93Encoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createCode93Extended() {
        JBarcode jBarcode = new JBarcode(Code93ExtEncoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createCode128() {
        JBarcode jBarcode = new JBarcode(Code128Encoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createMSIPlessey() {
        JBarcode jBarcode = new JBarcode(MSIPlesseyEncoder.getInstance(), WidthCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(true);
        return jBarcode;
    }

    public JBarcode createStandard2of5() {
        JBarcode jBarcode = new JBarcode(Standard2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createInterleaved2of5() {
        JBarcode jBarcode = new JBarcode(Interleaved2of5Encoder.getInstance(), WideRatioCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(17.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(true);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }

    public JBarcode createPostNet() {
        JBarcode jBarcode = new JBarcode(PostNetEncoder.getInstance(), HeightCodedPainter.getInstance(), BaseLineTextPainter.getInstance());
        jBarcode.setBarHeight(6.0);
        try {
            jBarcode.setXDimension(0.264583333);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            // empty catch block
        }
        jBarcode.setShowText(false);
        jBarcode.setCheckDigit(true);
        jBarcode.setShowCheckDigit(false);
        return jBarcode;
    }
}

