/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.demo;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.CodabarEncoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.encode.EAN8Encoder;
import org.jbarcode.encode.Interleaved2of5Encoder;
import org.jbarcode.encode.PostNetEncoder;
import org.jbarcode.encode.Standard2of5Encoder;
import org.jbarcode.encode.UPCAEncoder;
import org.jbarcode.encode.UPCEEncoder;
import org.jbarcode.paint.BaseLineTextPainter;
import org.jbarcode.paint.EAN13TextPainter;
import org.jbarcode.paint.EAN8TextPainter;
import org.jbarcode.paint.HeightCodedPainter;
import org.jbarcode.paint.UPCATextPainter;
import org.jbarcode.paint.UPCETextPainter;
import org.jbarcode.paint.WideRatioCodedPainter;
import org.jbarcode.paint.WidthCodedPainter;
import org.jbarcode.util.ImageUtil;

public class SimpleDemo {
    public static void main(String[] stringArray) {
        try {
            JBarcode jBarcode = new JBarcode(EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
            String string = "788515004012";
            BufferedImage bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToGIF(bufferedImage, "EAN13.gif");
            jBarcode.setEncoder(EAN8Encoder.getInstance());
            jBarcode.setTextPainter(EAN8TextPainter.getInstance());
            string = "9788515";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "EAN8.png");
            jBarcode.setEncoder(UPCAEncoder.getInstance());
            jBarcode.setTextPainter(UPCATextPainter.getInstance());
            string = "07567816415";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "UPCA.png");
            jBarcode.setEncoder(UPCEEncoder.getInstance());
            jBarcode.setTextPainter(UPCETextPainter.getInstance());
            string = UPCAEncoder.getInstance().convertUPCAtoUPCE("07567816415");
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "UPCE.png");
            jBarcode.setEncoder(CodabarEncoder.getInstance());
            jBarcode.setPainter(WideRatioCodedPainter.getInstance());
            jBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            string = "97885150040-85";
            jBarcode.setWideRatio(3.0);
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToJPEG(bufferedImage, "Codabar.jpg");
            jBarcode.setEncoder(Code39Encoder.getInstance());
            jBarcode.setPainter(WideRatioCodedPainter.getInstance());
            jBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            jBarcode.setShowCheckDigit(false);
            string = "JBARCODE-39";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "Code39.png");
            jBarcode.setEncoder(Code93Encoder.getInstance());
            jBarcode.setPainter(WidthCodedPainter.getInstance());
            jBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            jBarcode.setShowCheckDigit(false);
            string = "JBARCODE-93";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "Code93.png");
            jBarcode.setEncoder(Code128Encoder.getInstance());
            jBarcode.setPainter(WidthCodedPainter.getInstance());
            jBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            jBarcode.setShowCheckDigit(false);
            string = "JBarcode-128";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "Code128.png");
            jBarcode.setEncoder(Standard2of5Encoder.getInstance());
            jBarcode.setPainter(WideRatioCodedPainter.getInstance());
            jBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            jBarcode.setShowCheckDigit(true);
            string = "978851500404";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToJPEG(bufferedImage, "Standard2of5.jpg");
            jBarcode.setEncoder(Interleaved2of5Encoder.getInstance());
            jBarcode.setPainter(WideRatioCodedPainter.getInstance());
            jBarcode.setTextPainter(BaseLineTextPainter.getInstance());
            jBarcode.setShowCheckDigit(true);
            string = "978851500404";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToPNG(bufferedImage, "Interleaved2of5.png");
            jBarcode.setEncoder(PostNetEncoder.getInstance());
            jBarcode.setPainter(HeightCodedPainter.getInstance());
            jBarcode.setBarHeight(6.0);
            jBarcode.setXDimension(0.5291666);
            jBarcode.setShowText(false);
            string = "805365961";
            bufferedImage = jBarcode.createBarcode(string);
            SimpleDemo.saveToJPEG(bufferedImage, "PostNet.jpg");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void saveToJPEG(BufferedImage bufferedImage, String string) {
        SimpleDemo.saveToFile(bufferedImage, string, "jpeg");
    }

    static void saveToPNG(BufferedImage bufferedImage, String string) {
        SimpleDemo.saveToFile(bufferedImage, string, "png");
    }

    static void saveToGIF(BufferedImage bufferedImage, String string) {
        SimpleDemo.saveToFile(bufferedImage, string, "gif");
    }

    static void saveToFile(BufferedImage bufferedImage, String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("./images/" + string);
            ImageUtil.encodeAndWrite(bufferedImage, string2, fileOutputStream, 96, 96);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

