/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class CodabarEncoder
implements BarcodeEncoder {
    protected final BarSet[] CODES_WIDTH = new BarSet[]{new BarSet("0000011"), new BarSet("0000110"), new BarSet("0001001"), new BarSet("1100000"), new BarSet("0010010"), new BarSet("1000010"), new BarSet("0100001"), new BarSet("0100100"), new BarSet("0110000"), new BarSet("1001000"), new BarSet("0001100"), new BarSet("0011000"), new BarSet("1000101"), new BarSet("1010001"), new BarSet("1010100"), new BarSet("0011111"), new BarSet("0011010"), new BarSet("0001011"), new BarSet("0101001"), new BarSet("0001110")};
    protected BarSet INTER_CHAR = new BarSet("0");
    public static final int START_CHAR_A = 16;
    public static final int START_CHAR_B = 17;
    public static final int START_CHAR_C = 18;
    public static final int START_CHAR_D = 19;
    public static final int STOP_CHAR_T = 16;
    public static final int STOP_CHAR_N = 17;
    public static final int STOP_CHAR_ASTERISC = 18;
    public static final int STOP_CHAR_E = 19;
    private static CodabarEncoder instance;
    private int startChar = 16;
    private int stopChar = 18;

    private CodabarEncoder() {
    }

    public static CodabarEncoder getInstance() {
        if (instance == null) {
            instance = new CodabarEncoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[Codabar] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[2 * string.length() + 3];
        barSetArray[0] = this.CODES_WIDTH[this.startChar];
        for (int i = 0; i < string.length(); ++i) {
            barSetArray[i * 2 + 1] = this.INTER_CHAR;
            barSetArray[i * 2 + 2] = this.CODES_WIDTH[this.getCharIndex(string.charAt(i))];
        }
        barSetArray[barSetArray.length - 2] = this.INTER_CHAR;
        barSetArray[barSetArray.length - 1] = this.CODES_WIDTH[this.stopChar];
        return barSetArray;
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        return "";
    }

    private int getCharIndex(char c) throws InvalidAtributeException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c == '-') {
            return 10;
        }
        if (c == '$') {
            return 11;
        }
        if (c == ':') {
            return 12;
        }
        if (c == '/') {
            return 13;
        }
        if (c == '.') {
            return 14;
        }
        if (c == '+') {
            return 15;
        }
        throw new InvalidAtributeException("[Codabar] The text contains not suported chars (" + c + ").");
    }

    public int getStartChar() {
        return this.startChar;
    }

    public void setStartChar(int n) {
        this.startChar = n;
    }

    public int getStopChar() {
        return this.stopChar;
    }

    public void setStopChar(int n) {
        this.stopChar = n;
    }

    public String toString() {
        return "CODABAR";
    }
}

