/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Code39Encoder
implements BarcodeEncoder {
    private static Code39Encoder instance;
    protected BarSet[] CODES_WIDTH = new BarSet[]{new BarSet("000110100"), new BarSet("100100001"), new BarSet("001100001"), new BarSet("101100000"), new BarSet("000110001"), new BarSet("100110000"), new BarSet("001110000"), new BarSet("000100101"), new BarSet("100100100"), new BarSet("001100100"), new BarSet("100001001"), new BarSet("001001001"), new BarSet("101001000"), new BarSet("000011001"), new BarSet("100011000"), new BarSet("001011000"), new BarSet("000001101"), new BarSet("100001100"), new BarSet("001001100"), new BarSet("000011100"), new BarSet("100000011"), new BarSet("001000011"), new BarSet("101000010"), new BarSet("000010011"), new BarSet("100010010"), new BarSet("001010010"), new BarSet("000000111"), new BarSet("100000110"), new BarSet("001000110"), new BarSet("000010110"), new BarSet("110000001"), new BarSet("011000001"), new BarSet("111000000"), new BarSet("010010001"), new BarSet("110010000"), new BarSet("011010000"), new BarSet("010000101"), new BarSet("110000100"), new BarSet("011000100"), new BarSet("010101000"), new BarSet("010100010"), new BarSet("010001010"), new BarSet("000101010")};
    protected BarSet START_STOP_CHAR = new BarSet("010010100");
    protected BarSet INTER_CHAR = new BarSet("0");

    protected Code39Encoder() {
    }

    public static BarcodeEncoder getInstance() {
        if (instance == null) {
            instance = new Code39Encoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[Code39] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[2 * string.length() + 3];
        barSetArray[0] = this.START_STOP_CHAR;
        for (int i = 0; i < string.length(); ++i) {
            barSetArray[i * 2 + 1] = this.INTER_CHAR;
            barSetArray[i * 2 + 2] = this.CODES_WIDTH[this.getCharIndex(string.charAt(i))];
        }
        barSetArray[barSetArray.length - 2] = this.INTER_CHAR;
        barSetArray[barSetArray.length - 1] = this.START_STOP_CHAR;
        return barSetArray;
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += this.getCharIndex(string.charAt(i));
        }
        return Character.valueOf((char)this.getChar(n % 43)).toString();
    }

    private int getCharIndex(char c) throws InvalidAtributeException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 55;
        }
        if (c == '-') {
            return 36;
        }
        if (c == '.') {
            return 37;
        }
        if (c == ' ') {
            return 38;
        }
        if (c == '$') {
            return 39;
        }
        if (c == '/') {
            return 40;
        }
        if (c == '+') {
            return 41;
        }
        if (c == '%') {
            return 42;
        }
        throw new InvalidAtributeException("[Code39] The text contains unsuported chars.");
    }

    private int getChar(int n) throws InvalidAtributeException {
        if (n >= 0 && n <= 9) {
            return n + 48;
        }
        if (n >= 10 && n <= 35) {
            return n + 55;
        }
        if (n == 36) {
            return 45;
        }
        if (n == 37) {
            return 46;
        }
        if (n == 38) {
            return 32;
        }
        if (n == 39) {
            return 36;
        }
        if (n == 40) {
            return 47;
        }
        if (n == 41) {
            return 43;
        }
        if (n == 42) {
            return 37;
        }
        throw new InvalidAtributeException("[Code39] The text contains unsuported chars.");
    }

    public String toString() {
        return "CODE 39";
    }
}

