/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.Code39Encoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Code39ExtEncoder
extends Code39Encoder {
    protected static String[] CODES_TABLE = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    private static Code39ExtEncoder instance;

    protected Code39ExtEncoder() {
    }

    public static BarcodeEncoder getInstance() {
        if (instance == null) {
            instance = new Code39ExtEncoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        return super.encode(Code39ExtEncoder.convertText(string));
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        return super.computeCheckSum(Code39ExtEncoder.convertText(string));
    }

    public String toString() {
        return "CODE 39 (EXT)";
    }

    protected static String convertText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(CODES_TABLE[string.charAt(i)]);
        }
        return stringBuffer.toString();
    }
}

