/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.Code93Encoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Code93ExtEncoder
extends Code93Encoder {
    protected static String[] CODES_TABLE = new String[]{"\u00b2U", "\u00b9A", "\u00b9B", "\u00b9C", "\u00b9D", "\u00b9E", "\u00b9F", "\u00b9G", "\u00b9H", "\u00b9I", "\u00b9J", "\u00b9K", "\u00b9L", "\u00b9M", "\u00b9N", "\u00b9O", "\u00b9P", "\u00b9Q", "\u00b9R", "\u00b9S", "\u00b9T", "\u00b9U", "\u00b9V", "\u00b9W", "\u00b9X", "\u00b9Y", "\u00b9Z", "\u00b2A", "\u00b2B", "\u00b2C", "\u00b2D", "\u00b2E", " ", "\u00b3A", "\u00b3B", "\u00b3C", "\u00b3D", "\u00b3E", "\u00b3F", "\u00b3G", "\u00b3H", "\u00b3I", "\u00b3J", "\u00b3K", "\u00b3L", "-", ".", "\u00b3O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "\u00b3Z", "\u00b2F", "\u00b2G", "\u00b2H", "\u00b2I", "\u00b2J", "\u00b2V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\u00b2K", "\u00b2L", "\u00b2M", "\u00b2N", "\u00b2O", "\u00b2W", "\u00a3A", "\u00a3B", "\u00a3C", "\u00a3D", "\u00a3E", "\u00a3F", "\u00a3G", "\u00a3H", "\u00a3I", "\u00a3J", "\u00a3K", "\u00a3L", "\u00a3M", "\u00a3N", "\u00a3O", "\u00a3P", "\u00a3Q", "\u00a3R", "\u00a3S", "\u00a3T", "\u00a3U", "\u00a3V", "\u00a3W", "\u00a3X", "\u00a3Y", "\u00a3Z", "\u00b2P", "\u00b2Q", "\u00b2R", "\u00b2S", "\u00b2T"};
    private static Code93ExtEncoder instance;

    protected Code93ExtEncoder() {
    }

    public static BarcodeEncoder getInstance() {
        if (instance == null) {
            instance = new Code93ExtEncoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        return super.encode(this.convertText(string));
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        return super.computeCheckSum(this.convertText(string));
    }

    public String toString() {
        return "CODE 93 (EXT)";
    }

    protected String convertText(String string) throws InvalidAtributeException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '\u0080') {
                stringBuffer.append(CODES_TABLE[string.charAt(i)]);
                continue;
            }
            if (string.charAt(i) == '\u00b9' || string.charAt(i) == '\u00b2' || string.charAt(i) == '\u00b3' || string.charAt(i) == '\u00a3') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            throw new InvalidAtributeException("[Code93] The text contains unsuported chars.");
        }
        return stringBuffer.toString();
    }
}

