/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.EANEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class EAN13Encoder
extends EANEncoder {
    private static EAN13Encoder instance;
    protected BarSet[] DIGIT_PARITY = new BarSet[]{new BarSet("000000"), new BarSet("001011"), new BarSet("001101"), new BarSet("001110"), new BarSet("010011"), new BarSet("011001"), new BarSet("011100"), new BarSet("010101"), new BarSet("010110"), new BarSet("011010")};

    protected EAN13Encoder() {
    }

    public static EAN13Encoder getInstance() {
        if (instance == null) {
            instance = new EAN13Encoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 12 || string.length() > 13) {
            throw new InvalidAtributeException("[EAN13] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[15];
        try {
            int n;
            int n2 = EAN13Encoder.charToInt(string.charAt(0));
            barSetArray[0] = LEFT_GUARD;
            for (n = 1; n <= 6; ++n) {
                int n3 = EAN13Encoder.charToInt(string.charAt(n));
                barSetArray[n] = this.DIGIT_PARITY[n2].get(n - 1) ? CODES[n3].reverse() : CODES[n3].xorTrue();
            }
            barSetArray[7] = CENTER_GUARD;
            for (n = 7; n <= 12; ++n) {
                barSetArray[n + 1] = CODES[EAN13Encoder.charToInt(string.charAt(n))];
            }
            barSetArray[14] = RIGTH_GUARD;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAtributeException("[EAN13] Only numbers suported.");
        }
        return barSetArray;
    }

    public String toString() {
        return "EAN 13";
    }
}

