/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jbarcode.encode.BarSet;
import org.jbarcode.paint.BarcodePainter;

public class CircularPainter
implements BarcodePainter {
    private static BarcodePainter instance;

    private CircularPainter() {
    }

    public static BarcodePainter getInstance() {
        if (instance == null) {
            instance = new CircularPainter();
        }
        return instance;
    }

    public BufferedImage paint(BarSet[] barSetArray, int n, int n2, double d) {
        float f = 0.0f;
        float f2 = (float)((double)n * d);
        for (int i = 0; i < barSetArray.length; ++i) {
            for (int j = 0; j < barSetArray[i].length(); ++j) {
                if (barSetArray[i].get(j)) {
                    f += f2;
                    continue;
                }
                f += (float)n;
            }
        }
        float f3 = Math.max(2.0f * f, (float)(2 * n2));
        BufferedImage bufferedImage = new BufferedImage((int)f3, (int)f3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setColor(Color.BLACK);
        float f4 = 0.0f;
        boolean bl = true;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, Math.round(f3), Math.round(f3));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(f3 / 2.0f, f3 / 2.0f);
        graphics2D.transform(affineTransform);
        f4 = -f3 / 2.0f;
        for (int i = 0; i < barSetArray.length; ++i) {
            for (int j = 0; j < barSetArray[i].length(); ++j) {
                float f5 = f = barSetArray[i].get(j) ? f2 : (float)n;
                if (bl) {
                    int n3 = (int)(f4 + f / 2.0f);
                    graphics2D.setStroke(new BasicStroke(f));
                    graphics2D.drawOval(n3, n3, Math.abs(2 * n3), Math.abs(2 * n3));
                    graphics2D.setColor(Color.WHITE);
                } else {
                    graphics2D.setColor(Color.BLACK);
                }
                bl = !bl;
                f4 += f;
            }
        }
        return bufferedImage;
    }
}

