/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.paint;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.jbarcode.paint.TextPainter;

public class UPCETextPainter
implements TextPainter {
    private static TextPainter instance;

    private UPCETextPainter() {
    }

    public static TextPainter getInstance() {
        if (instance == null) {
            instance = new UPCETextPainter();
        }
        return instance;
    }

    public void paintText(BufferedImage bufferedImage, String string, int n) {
        Graphics graphics = bufferedImage.getGraphics();
        Font font = new Font("monospace", 0, 11 * n);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = n * 42;
        int n3 = fontMetrics.getHeight();
        int n4 = (n2 - fontMetrics.stringWidth("000000") + 2 * n) / 2;
        int n5 = bufferedImage.getHeight() - n3 / 10;
        int n6 = n * 13;
        int n7 = bufferedImage.getHeight() - n3 * 4 / 5;
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight() * 1 / 20);
        graphics.fillRect(0, bufferedImage.getHeight() - n3 / 3, bufferedImage.getWidth(), n3 / 3);
        graphics.fillRect(n6, n7, n2, n3);
        graphics.setColor(Color.BLACK);
        graphics.drawString(string.substring(0, 1), 10 * n - fontMetrics.stringWidth("0"), n5);
        graphics.drawString(string.substring(1, 7), n6 + n4, n5);
        graphics.drawString(string.substring(7), bufferedImage.getWidth() - 8 * n, n5);
    }
}

