/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class OpenLinkEvent
extends EventObject {
    public static final int SAME_WINDOW_EVENT = 1;
    public static final int NEW_WINDOW_EVENT = 2;
    private final String link;
    private final int id;
    private final URL url;

    public OpenLinkEvent(IWebBrowser source, int id, String link) {
        super(source);
        this.id = id;
        this.link = link;
        this.url = link != null ? this.createURL(link) : null;
    }

    public IWebBrowser getBrowser() {
        return (IWebBrowser)this.getSource();
    }

    public int getID() {
        return this.id;
    }

    public String getLink() {
        return this.link;
    }

    public URL getURL() {
        return this.url;
    }

    private URL createURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException ex1) {
            try {
                return new URL(String.valueOf(BrowserEngineManager.instance().getActiveEngine().getFileProtocolURLPrefix()) + urlString);
            }
            catch (MalformedURLException e) {
                WebBrowserUtil.trace(e.toString());
                return null;
            }
        }
    }
}

