/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.internal.NativeEventData;
import org.jdesktop.jdic.browser.internal.NativeEventThread;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class MsgClient {
    private static final int MAX_RETRY = 30;
    private static final int BUFFERSIZE = 2048;
    private static final String MSG_DELIMITER = "</html><body></html>";
    private static final String MSG_DELIMITER_ = "</html><body></html>_";
    private static final String MSG_DELIMITER_HEAD = "</html><body></html>_head";
    private static final String MSG_DELIMITER_MIDDLE = "</html><body></html>_middle";
    private static final String MSG_DELIMITER_END = "</html><body></html>_end";
    private Selector selector = null;
    private SocketChannel channel = null;
    private int port;
    private InetSocketAddress serverAddr;
    private String charsetName = null;
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;
    private ByteBuffer buffer;
    private CharBuffer charBuffer;
    private String sendBuffer = new String();
    private String recvBuffer = new String();
    private static Set msgPieces = new HashSet();

    public MsgClient() {
        WebBrowserUtil.trace("Msg Client started");
        this.charsetName = BrowserEngineManager.instance().getActiveEngine().getCharsetName();
        Charset charset = Charset.forName(this.charsetName);
        this.decoder = charset.newDecoder();
        this.encoder = charset.newEncoder();
        this.buffer = ByteBuffer.allocateDirect(2048);
        this.charBuffer = CharBuffer.allocate(2048);
        try {
            this.selector = Selector.open();
            this.port = this.findAFreePort();
            this.serverAddr = new InetSocketAddress("localhost", this.port);
            WebBrowserUtil.trace("Found a free socket port: " + this.port);
        }
        catch (Exception e) {
            WebBrowserUtil.error(e.getMessage());
        }
    }

    public int getPort() {
        return this.port;
    }

    void connect() throws IOException, InterruptedException {
        int retry = 0;
        while (retry < 30) {
            WebBrowserUtil.trace("Connecting to native browser ... " + retry);
            try {
                this.channel = SocketChannel.open();
                this.channel.configureBlocking(false);
                this.channel.connect(this.serverAddr);
                this.channel.register(this.selector, 8);
                block5: while (!this.channel.isConnected()) {
                    if (this.selector.select() <= 0) continue;
                    Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> i = readyKeys.iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        i.remove();
                        SocketChannel keyChannel = (SocketChannel)key.channel();
                        if (!key.isConnectable()) continue;
                        if (!keyChannel.isConnectionPending()) continue block5;
                        keyChannel.finishConnect();
                        continue block5;
                    }
                }
                break;
            }
            catch (Exception e) {
                WebBrowserUtil.trace(e.toString());
                this.channel.close();
                this.channel = null;
                try {
                    Thread.sleep(150L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++retry;
            }
        }
        if (retry == 30) {
            throw new InterruptedException("Maximum retry number reached!");
        }
        WebBrowserUtil.trace("connected");
        this.channel.keyFor(this.selector).interestOps(5);
    }

    public void sendMessage(String msg) {
        this.sendBuffer = String.valueOf(this.sendBuffer) + msg + MSG_DELIMITER;
    }

    public String getMessage() {
        int pos = this.recvBuffer.indexOf(MSG_DELIMITER);
        if (pos < 0) {
            return null;
        }
        String msg = this.recvBuffer.substring(0, pos);
        if (pos != this.recvBuffer.indexOf(MSG_DELIMITER_)) {
            this.recvBuffer = this.recvBuffer.substring(pos + new String(MSG_DELIMITER).length());
            WebBrowserUtil.trace("Got a complete short message: " + msg);
            return msg;
        }
        NativeEventData eventData = NativeEventThread.parseMessageString(msg);
        if (pos == this.recvBuffer.indexOf(MSG_DELIMITER_HEAD)) {
            msgPieces.add(new NativeEventData(eventData.instance, eventData.type, eventData.stringValue));
            this.recvBuffer = this.recvBuffer.substring(pos + new String(MSG_DELIMITER_HEAD).length());
            WebBrowserUtil.trace("Got a head message piece: " + eventData.stringValue);
            return null;
        }
        for (NativeEventData element : msgPieces) {
            if (element.instance != eventData.instance || element.type != eventData.type) continue;
            if (pos == this.recvBuffer.indexOf(MSG_DELIMITER_MIDDLE)) {
                NativeEventData newElement = new NativeEventData(eventData.instance, eventData.type, String.valueOf(element.stringValue) + eventData.stringValue);
                msgPieces.remove(element);
                msgPieces.add(newElement);
                this.recvBuffer = this.recvBuffer.substring(pos + new String(MSG_DELIMITER_MIDDLE).length());
                WebBrowserUtil.trace("Got a middle message piece: " + eventData.stringValue);
                return null;
            }
            if (pos != this.recvBuffer.indexOf(MSG_DELIMITER_END)) continue;
            msg = String.valueOf(eventData.instance) + "," + eventData.type + "," + element.stringValue + eventData.stringValue;
            msgPieces.remove(element);
            this.recvBuffer = this.recvBuffer.substring(pos + new String(MSG_DELIMITER_END).length());
            WebBrowserUtil.trace("Got an end message piece: " + eventData.stringValue);
            WebBrowserUtil.trace("Got a complete long message: " + element.stringValue + eventData.stringValue);
            return msg;
        }
        return null;
    }

    public void portListening() throws IOException, InterruptedException {
        if (this.selector != null && this.selector.select(1L) > 0) {
            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> i = readyKeys.iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                i.remove();
                SocketChannel keyChannel = (SocketChannel)key.channel();
                if (key.isReadable()) {
                    this.readFromChannel(keyChannel);
                    continue;
                }
                if (!key.isWritable()) continue;
                this.writeToChannel(keyChannel);
            }
        }
    }

    private void readFromChannel(SocketChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(2048);
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while (channel.read(buffer) > 0) {
            buffer.flip();
            this.decoder.decode(buffer, charBuffer, false);
            charBuffer.flip();
            this.recvBuffer = String.valueOf(this.recvBuffer) + charBuffer;
            charBuffer.clear();
            buffer.clear();
            WebBrowserUtil.trace("Read data from socket: " + this.recvBuffer);
        }
    }

    private void writeToChannel(SocketChannel keyChannel) throws IOException {
        if (this.sendBuffer.length() > 0) {
            WebBrowserUtil.trace("Send data to socket: " + this.sendBuffer);
            ByteBuffer buf = ByteBuffer.wrap(this.sendBuffer.getBytes(this.charsetName));
            keyChannel.write(buf);
            while (buf.hasRemaining()) {
                WebBrowserUtil.trace("==there're still contens in write buffer==");
                keyChannel.write(buf);
            }
            this.sendBuffer = "";
        }
    }

    private int findAFreePort() throws IOException {
        ServerSocketChannel tmpServerSocket = ServerSocketChannel.open();
        tmpServerSocket.socket().bind(new InetSocketAddress("localhost", 0));
        int resultPort = tmpServerSocket.socket().getLocalPort();
        tmpServerSocket.close();
        return resultPort;
    }
}

