/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.internal.MsgClient;
import org.jdesktop.jdic.browser.internal.NativeEventData;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class NativeEventThread
extends Thread {
    private Vector webBrowsers = new Vector();
    private Vector nativeEvents = new Vector();
    private Process nativeBrowserProcess;
    private String eventRetString;
    private MsgClient messenger = null;
    private IBrowserEngine engine = null;
    private boolean stopThreads = false;
    private static NativeEventThread nativeEventThread = null;

    public static NativeEventThread getInstance() throws Exception {
        if (nativeEventThread == null) {
            nativeEventThread = new NativeEventThread();
            nativeEventThread.start();
        }
        return nativeEventThread;
    }

    private NativeEventThread() throws Exception {
        super("EventThread");
        WebBrowserUtil.loadLibrary();
        this.init();
    }

    public void run() {
        WebBrowserUtil.trace("Envent thread started");
        while (!this.stopThreads) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.processEventsFromJava();
                this.messenger.portListening();
                this.processMessageFromNative(this.messenger.getMessage());
            }
            catch (Exception e) {
                WebBrowserUtil.trace("Exception occured when portListening: " + e.getMessage());
                return;
            }
        }
        WebBrowserUtil.trace("Main thread exit.");
    }

    public void attachWebBrowser(IWebBrowser webBrowser) {
        int instanceNum = webBrowser.getInstanceNum();
        if (instanceNum >= this.webBrowsers.size()) {
            this.webBrowsers.setSize(instanceNum + 1);
        }
        this.webBrowsers.set(instanceNum, webBrowser);
    }

    public static NativeEventData parseMessageString(String msg) {
        if (msg == null || msg.length() == 0) {
            return null;
        }
        int eventType = -1;
        String stringValue = null;
        int pos1 = msg.indexOf(",", 0);
        int instance = Integer.parseInt(msg.substring(0, pos1));
        int pos2 = msg.indexOf(",", pos1 + 1);
        if (pos2 < 0) {
            eventType = Integer.parseInt(msg.substring(pos1 + 1));
        } else {
            eventType = Integer.parseInt(msg.substring(pos1 + 1, pos2));
            if (pos2 + 1 < msg.length()) {
                stringValue = msg.substring(pos2 + 1);
            }
        }
        return new NativeEventData(instance, eventType, stringValue);
    }

    public String getEventRetString() {
        return this.eventRetString;
    }

    public MsgClient getMessenger() {
        return this.messenger;
    }

    public synchronized void fireNativeEvent(int instance, int type) {
        this.nativeEvents.addElement(new NativeEventData(instance, type));
    }

    public synchronized void fireNativeEvent(int instance, int type, Rectangle rectValue) {
        this.nativeEvents.addElement(new NativeEventData(instance, type, rectValue));
    }

    public synchronized void fireNativeEvent(int instance, int type, String stringValue) {
        this.nativeEvents.addElement(new NativeEventData(instance, type, stringValue));
    }

    public void setBrowsersInitFailReason(String msg) {
        ((IWebBrowser)this.webBrowsers.elementAt(0)).setInitFailureMessage(msg);
    }

    private void init() throws PrivilegedActionException, JdicInitException {
        try {
            this.messenger = new MsgClient();
            this.engine = BrowserEngineManager.instance().getActiveEngine();
            this.engine.initialize();
            String filepath = String.valueOf(JdicManager.getManager().getBinaryPath()) + File.separator + this.engine.getEmbeddedBinaryName();
            final String cmd = new File(filepath).exists() ? filepath : this.engine.getEmbeddedBinaryName();
            WebBrowserUtil.trace("Executing " + cmd + " -port=" + this.messenger.getPort());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    NativeEventThread.this.nativeBrowserProcess = Runtime.getRuntime().exec(new String[]{cmd, "-port=" + NativeEventThread.this.messenger.getPort()});
                    new StreamGobbler(NativeEventThread.this.nativeBrowserProcess.getErrorStream()).start();
                    new StreamGobbler(NativeEventThread.this.nativeBrowserProcess.getInputStream()).start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.setBrowsersInitFailReason("Can't find the native embedded browser.");
            WebBrowserUtil.error("Can't execute the native embedded browser. Error message: " + e.getCause().getMessage());
            throw e;
        }
        catch (JdicInitException inie) {
            WebBrowserUtil.error(inie.getMessage());
            inie.printStackTrace();
            throw inie;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NativeEventThread.this.messenger.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            WebBrowserUtil.error("Can't connect to the native embedded browser. Error message: " + e.getCause().getMessage());
            this.setBrowsersInitFailReason("Can't connect to the native embedded browser.");
            throw e;
        }
        NativeProcessMonitor npm = new NativeProcessMonitor();
        npm.setDaemon(true);
        npm.start();
        this.fireNativeEvent(-1, 0);
    }

    private IWebBrowser getWebBrowserFromInstance(int instance) {
        try {
            return (IWebBrowser)this.webBrowsers.get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWebBrowser(int instance) {
        IWebBrowser browser = this.getWebBrowserFromInstance(instance);
        if (browser != null) {
            IWebBrowser iWebBrowser = browser;
            synchronized (iWebBrowser) {
                browser.notify();
            }
        }
    }

    private void processEventsFromJava() {
        int size = this.nativeEvents.size();
        int i = 0;
        while (i < size) {
            NativeEventData nativeEvent = (NativeEventData)this.nativeEvents.get(i);
            if (this.processEventFromJava(nativeEvent)) {
                this.nativeEvents.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    private boolean processEventFromJava(NativeEventData nativeEvent) {
        IWebBrowser browser = null;
        if (nativeEvent.type != 0) {
            browser = this.getWebBrowserFromInstance(nativeEvent.instance);
            if (browser == null) {
                return true;
            }
            if (!browser.isInitialized() && nativeEvent.type != 0 && nativeEvent.type != 1 && nativeEvent.type != 3) {
                return false;
            }
        }
        WebBrowserUtil.trace("Process event to native browser: " + nativeEvent.instance + ", " + nativeEvent.type + ", ");
        String msg = String.valueOf(nativeEvent.instance) + "," + nativeEvent.type + ",";
        switch (nativeEvent.type) {
            case 0: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.messenger.sendMessage(msg);
                break;
            }
            case 3: {
                this.messenger.sendMessage(msg);
                break;
            }
            case 1: {
                int nativeWindow = browser.getNativeWindow();
                if (nativeWindow == 0) {
                    WebBrowserUtil.trace("Can't get the JAWT native window handler.");
                    break;
                }
                msg = String.valueOf(msg) + nativeWindow;
                this.messenger.sendMessage(msg);
                break;
            }
            case 4: {
                msg = String.valueOf(msg) + nativeEvent.rectValue.x + "," + nativeEvent.rectValue.y + "," + nativeEvent.rectValue.width + "," + nativeEvent.rectValue.height;
                this.messenger.sendMessage(msg);
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: {
                msg = String.valueOf(msg) + nativeEvent.stringValue;
                this.messenger.sendMessage(msg);
            }
        }
        return true;
    }

    private void processMessageFromNative(String msg) {
        NativeEventData eventData = NativeEventThread.parseMessageString(msg);
        if (eventData == null) {
            return;
        }
        WebBrowserUtil.trace("Process event from native browser: " + eventData.instance + ", " + eventData.type + ", " + eventData.stringValue);
        if (3041 == eventData.type) {
            this.setBrowsersInitFailReason(eventData.stringValue);
            WebBrowserUtil.error(eventData.stringValue);
            return;
        }
        if (eventData.instance < 0) {
            return;
        }
        final IWebBrowser browser = this.getWebBrowserFromInstance(eventData.instance);
        if (browser == null) {
            return;
        }
        if (3007 == eventData.type && browser.isSynchronize()) {
            this.notifyWebBrowser(eventData.instance);
            return;
        }
        if (3021 == eventData.type || 3061 == eventData.type || 3063 == eventData.type || 3044 == eventData.type) {
            this.eventRetString = eventData.stringValue;
            this.notifyWebBrowser(eventData.instance);
            return;
        }
        if (3042 == eventData.type) {
            browser.setInitialized(true);
            browser.setInitFailureMessage("");
        }
        final WebBrowserEvent event = new WebBrowserEvent(browser, eventData.type, eventData.stringValue);
        Runnable dispatchEvent = new Runnable(){

            public void run() {
                browser.dispatchWebBrowserEvent(event);
            }
        };
        try {
            SwingUtilities.invokeLater(dispatchEvent);
        }
        catch (Exception e) {
            WebBrowserUtil.trace("Exception occured when invokeLater. Error message: " + e.getMessage());
        }
    }

    class NativeProcessMonitor
    extends Thread {
        NativeProcessMonitor() {
        }

        public void run() {
            try {
                try {
                    NativeEventThread.this.nativeBrowserProcess.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    NativeEventThread.this.nativeBrowserProcess.destroy();
                    NativeEventThread.this.stopThreads = true;
                    NativeEventThread.nativeEventThread = null;
                    WebBrowserUtil.trace("Native web browser died.");
                }
            }
            finally {
                NativeEventThread.this.stopThreads = true;
                NativeEventThread.nativeEventThread = null;
                WebBrowserUtil.trace("Native web browser died.");
            }
        }
    }

    class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null && !NativeEventThread.this.stopThreads) {
                    WebBrowserUtil.trace("+++ Ctrace: " + line);
                }
                if (NativeEventThread.this.stopThreads) {
                    WebBrowserUtil.trace("StreamGobbler exited.");
                    return;
                }
                WebBrowserUtil.trace("StreamGobbler exited.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

