/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser.internal;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class WebBrowserUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String JAVA_DOT_HOME = "java.home";
    public static final boolean IS_OS_WINDOWS = WebBrowserUtil.isCurrentOS("Windows");
    public static final boolean IS_OS_LINUX = WebBrowserUtil.isCurrentOS("Linux");
    public static final boolean IS_OS_SUNOS = WebBrowserUtil.isCurrentOS("SunOS");
    public static final boolean IS_OS_FREEBSD = WebBrowserUtil.isCurrentOS("FreeBSD");
    public static final boolean IS_OS_MAC = WebBrowserUtil.isCurrentOS("Mac");
    private static final String JDIC_LIB_NAME = "jdic";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String PATH = "PATH";
    public static final String LIB_PATH_ENV = IS_OS_WINDOWS ? "PATH" : "LD_LIBRARY_PATH";
    private static String browserPath = null;
    private static boolean nativeLibLoaded = false;
    private static boolean isDebugOn = false;

    private static native String nativeGetBrowserPath();

    private static native String nativeGetMozillaGreHome();

    private static native void nativeSetEnv();

    public static void loadLibrary() {
        if (!nativeLibLoaded) {
            try {
                Toolkit.getDefaultToolkit();
                JdicManager.getManager().initShareNative();
            }
            catch (JdicInitException e) {
                e.printStackTrace();
                WebBrowserUtil.error(e.getMessage());
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary(WebBrowserUtil.JDIC_LIB_NAME);
                    return null;
                }
            });
            nativeLibLoaded = true;
        }
    }

    public static String getDefaultBrowserPath() {
        if (browserPath == null) {
            WebBrowserUtil.loadLibrary();
            browserPath = WebBrowserUtil.nativeGetBrowserPath();
        }
        return browserPath;
    }

    public static String getMozillaGreHome() {
        WebBrowserUtil.loadLibrary();
        return WebBrowserUtil.nativeGetMozillaGreHome();
    }

    public static boolean isCurrentOS(String osname) {
        if (osname == null) {
            return false;
        }
        return OS_NAME.indexOf(osname) >= 0;
    }

    public static void trace(String msg) {
        if (isDebugOn) {
            System.out.println("*** Jtrace: " + msg);
        }
        Logger.getLogger(WebBrowser.class).info((Object)("*** Jtrace: " + msg));
    }

    public static void error(String msg) {
        System.err.println("*** Error: " + msg);
        Logger.getLogger(WebBrowser.class).error((Object)msg);
    }

    public static void enableDebugMessages(boolean b) {
        isDebugOn = b;
    }

    public static boolean getDebug() {
        return isDebugOn;
    }

    public static void nativeSetEnvironment() {
        WebBrowserUtil.loadLibrary();
        WebBrowserUtil.nativeSetEnv();
    }

    public static void copyIsToOs(InputStream is, OutputStream os) {
        int perNum = 1024;
        byte[] contents = new byte[perNum];
        int readLengh = 0;
        try {
            try {
                while ((readLengh = is.read(contents, 0, perNum)) > 0) {
                    os.write(contents, 0, readLengh);
                }
            }
            catch (IOException e) {
                WebBrowserUtil.error(e.getMessage());
                e.printStackTrace();
                try {
                    os.flush();
                    os.close();
                    is.close();
                }
                catch (IOException e2) {
                    WebBrowserUtil.error(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                os.flush();
                os.close();
                is.close();
            }
            catch (IOException e) {
                WebBrowserUtil.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

