/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop;

import java.io.File;
import java.net.URL;
import org.jdesktop.jdic.desktop.DesktopException;
import org.jdesktop.jdic.desktop.Message;
import org.jdesktop.jdic.desktop.internal.BrowserService;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.LaunchService;
import org.jdesktop.jdic.desktop.internal.MailerService;
import org.jdesktop.jdic.desktop.internal.ServiceManager;

public class Desktop {
    private Desktop() {
    }

    private static void checkFileValid(File file) throws DesktopException {
        if (file == null || !file.exists()) {
            throw new DesktopException("The given file doesn't exist.");
        }
        if (!file.canRead()) {
            throw new DesktopException("The given file couldn't be read.");
        }
    }

    public static void open(File file) throws DesktopException {
        if (file == null) {
            throw new DesktopException("The given file is null.");
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File resolvedFile = launchService.resolveLinkFile(file);
        Desktop.checkFileValid(resolvedFile);
        try {
            launchService.open(resolvedFile);
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }

    public static boolean isPrintable(File file) {
        if (file == null) {
            return false;
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File resolvedFile = launchService.resolveLinkFile(file);
        try {
            Desktop.checkFileValid(resolvedFile);
        }
        catch (DesktopException e) {
            return false;
        }
        return launchService.isPrintable(resolvedFile);
    }

    public static void print(File file) throws DesktopException {
        if (file == null) {
            throw new DesktopException("The given file is null.");
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File resolvedFile = launchService.resolveLinkFile(file);
        Desktop.checkFileValid(resolvedFile);
        if (!Desktop.isPrintable(resolvedFile)) {
            throw new DesktopException("The given file is not printable.");
        }
        try {
            launchService.print(resolvedFile);
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }

    public static boolean isEditable(File file) {
        if (file == null) {
            return false;
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File resolvedFile = launchService.resolveLinkFile(file);
        try {
            Desktop.checkFileValid(resolvedFile);
        }
        catch (DesktopException e) {
            return false;
        }
        return launchService.isEditable(resolvedFile);
    }

    public static void edit(File file) throws DesktopException {
        if (file == null) {
            throw new DesktopException("The given file is null.");
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File resolvedFile = launchService.resolveLinkFile(file);
        Desktop.checkFileValid(resolvedFile);
        if (!Desktop.isEditable(resolvedFile)) {
            throw new DesktopException("The given file is not editable.");
        }
        try {
            launchService.edit(resolvedFile);
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }

    public static void browse(URL url) throws DesktopException {
        if (url == null) {
            throw new DesktopException("The given URL is null.");
        }
        BrowserService browserService = (BrowserService)ServiceManager.getService("BrowserService");
        try {
            browserService.show(url);
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }

    private static void browse(URL url, String target) throws DesktopException {
        if (url == null) {
            throw new DesktopException("The given URL is null.");
        }
        if (target == null) {
            throw new DesktopException("The given target is null.");
        }
        BrowserService browserService = (BrowserService)ServiceManager.getService("BrowserService");
        try {
            browserService.show(url, target);
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }

    public static void mail() throws DesktopException {
        MailerService mailerService = (MailerService)ServiceManager.getService("MailerService");
        try {
            mailerService.open();
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }

    public static void mail(Message msg) throws DesktopException {
        if (msg == null) {
            throw new DesktopException("The given message is null.");
        }
        MailerService mailerService = (MailerService)ServiceManager.getService("MailerService");
        try {
            mailerService.open(msg);
        }
        catch (LaunchFailedException e) {
            throw new DesktopException(e.getMessage());
        }
    }
}

