/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import org.jdesktop.jdic.desktop.internal.impl.WinBrowserService;
import org.jdesktop.jdic.desktop.internal.impl.WinLaunchService;
import org.jdesktop.jdic.desktop.internal.impl.WinMapiMailer;
import org.jdesktop.jdic.desktop.internal.impl.WinMozMailer;
import org.jdesktop.jdic.desktop.internal.impl.WinUtility;

public class ServiceManagerStub {
    private ServiceManagerStub() {
    }

    public static Object getService(String serviceName) throws IllegalArgumentException {
        if (serviceName.equals("LaunchService")) {
            return new WinLaunchService();
        }
        if (serviceName.equals("BrowserService")) {
            return new WinBrowserService();
        }
        if (serviceName.equals("MailerService")) {
            String defMailer = WinUtility.getDefaultMailer();
            if (defMailer.equalsIgnoreCase("Mozilla") || defMailer.equalsIgnoreCase("Mozilla Thunderbird")) {
                String mailerLocation = WinUtility.getMozMailerLocation(defMailer);
                return new WinMozMailer(mailerLocation);
            }
            if ((defMailer.equalsIgnoreCase("Microsoft Outlook") || defMailer.equalsIgnoreCase("Outlook Express")) && WinUtility.isMapiSupported()) {
                return new WinMapiMailer();
            }
            throw new UnsupportedOperationException("Current system default mailer is not supported.");
        }
        throw new IllegalArgumentException("The requested service is not supported.");
    }
}

