/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.File;
import java.io.IOException;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.LaunchService;
import org.jdesktop.jdic.desktop.internal.impl.WinAPIWrapper;
import org.jdesktop.jdic.desktop.internal.impl.WinUtility;

public class WinLaunchService
implements LaunchService {
    private static final String LINK_FILE_SUFFIX = ".lnk";

    private boolean isLinkFile(File file) {
        return file.getPath().toLowerCase().endsWith(LINK_FILE_SUFFIX);
    }

    public File resolveLinkFile(File inputFile) {
        String fileStr;
        String targetFileStr;
        File resolvedFile = inputFile;
        try {
            resolvedFile = inputFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isLinkFile(resolvedFile) && (targetFileStr = WinAPIWrapper.WinResolveLinkFile(fileStr = resolvedFile.toString())) != null) {
            resolvedFile = new File(targetFileStr);
        }
        return resolvedFile;
    }

    public void open(File file) throws LaunchFailedException {
        if (file.isDirectory()) {
            if (!WinAPIWrapper.WinShellExecute(file.toString(), "open")) {
                throw new LaunchFailedException("Failed to open the given directory.");
            }
            return;
        }
        boolean findOpenNew = false;
        String appCommand = WinUtility.getVerbCommand(file, "opennew");
        if (appCommand != null) {
            findOpenNew = true;
        } else {
            appCommand = WinUtility.getVerbCommand(file, "open");
        }
        if (appCommand != null) {
            boolean result = findOpenNew ? WinAPIWrapper.WinShellExecute(file.toString(), "opennew") : WinAPIWrapper.WinShellExecute(file.toString(), "open");
            if (!result) {
                throw new LaunchFailedException("Failed to launch the associationed application");
            }
        } else {
            throw new LaunchFailedException("No application associated with the specified file");
        }
    }

    public boolean isEditable(File file) {
        String verbCommand = WinUtility.getVerbCommand(file, "edit");
        return verbCommand != null;
    }

    public void edit(File file) throws LaunchFailedException {
        if (this.isEditable(file)) {
            boolean result = WinAPIWrapper.WinShellExecute(file.toString(), "edit");
            if (!result) {
                throw new LaunchFailedException("Failed to edit the file.");
            }
        } else {
            throw new LaunchFailedException("No application associated with the specified file");
        }
    }

    public boolean isPrintable(File file) {
        String verbCommand = WinUtility.getVerbCommand(file, "print");
        return verbCommand != null;
    }

    public void print(File file) throws LaunchFailedException {
        if (this.isPrintable(file)) {
            boolean result = WinAPIWrapper.WinShellExecute(file.toString(), "print");
            if (!result) {
                throw new LaunchFailedException("Failed to print the file.");
            }
        } else {
            throw new LaunchFailedException("No application associated with the specified file");
        }
    }
}

