/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.filetypes.internal;

import java.util.Iterator;
import java.util.List;
import org.jdesktop.jdic.filetypes.Association;
import org.jdesktop.jdic.filetypes.RegisterFailedException;
import org.jdesktop.jdic.filetypes.internal.AppAssociationWriter;
import org.jdesktop.jdic.filetypes.internal.WinRegistryUtil;

public class WinAppAssociationWriter
implements AppAssociationWriter {
    private void restoreAssociationRegistration(BackupAssociation backupAssoc, int regLevel) {
        try {
            String curMimeType = backupAssoc.getCurMimeType();
            String curFileExt = backupAssoc.getCurFileExt();
            if (!backupAssoc.getCurMimeTypeExisted()) {
                if (curMimeType != null) {
                    WinRegistryUtil.removeMimeType(curMimeType, regLevel);
                }
            } else {
                String backupFileExt = backupAssoc.getBackupFileExt();
                if (backupFileExt != null) {
                    WinRegistryUtil.setFileExtByMimeType(backupFileExt, curMimeType, regLevel);
                }
            }
            if (!backupAssoc.getCurFileExtExisted()) {
                if (curFileExt != null) {
                    WinRegistryUtil.removeFileExt(curFileExt, regLevel);
                }
            } else {
                String backupClassID;
                String backupMimeType = backupAssoc.getBackupMimeType();
                if (backupMimeType != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(backupMimeType, curFileExt, regLevel);
                }
                if ((backupClassID = backupAssoc.getBackupClassID()) != null) {
                    WinRegistryUtil.setClassIDByFileExt(curFileExt, backupClassID, regLevel);
                }
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    private void restoreAssociationUnregistration(BackupAssociation backupAssoc, int regLevel) {
        try {
            String curMimeType = backupAssoc.getCurMimeType();
            String curFileExt = backupAssoc.getCurFileExt();
            if (backupAssoc.getCurMimeTypeExisted()) {
                WinRegistryUtil.addMimeType(curMimeType, regLevel);
                String backupFileExt = backupAssoc.getBackupFileExt();
                if (backupFileExt != null) {
                    WinRegistryUtil.setFileExtByMimeType(backupFileExt, curMimeType, regLevel);
                }
            }
            if (backupAssoc.getCurFileExtExisted()) {
                WinRegistryUtil.addFileExt(curFileExt, regLevel);
                String backupMimeType = backupAssoc.getBackupMimeType();
                String backupClassID = backupAssoc.getBackupClassID();
                if (backupMimeType != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(backupMimeType, curFileExt, regLevel);
                }
                if (backupClassID != null) {
                    WinRegistryUtil.setClassIDByFileExt(curFileExt, backupClassID, regLevel);
                }
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    public void checkAssociationValidForRegistration(Association assoc) throws IllegalArgumentException {
        boolean isActionListEmpty = true;
        boolean isFileExtensionEmpty = true;
        boolean isValid = false;
        if (assoc.getActionList() != null) {
            isActionListEmpty = assoc.getActionList().isEmpty();
        }
        if (assoc.getFileExtList() != null) {
            isFileExtensionEmpty = assoc.getFileExtList().isEmpty();
        }
        if (!(isValid = isFileExtensionEmpty && assoc.getMimeType() == null ? false : (assoc.getDescription() != null || assoc.getIconFileName() != null || !isActionListEmpty ? !isFileExtensionEmpty : true))) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    public void checkAssociationValidForUnregistration(Association assoc) throws IllegalArgumentException {
        boolean isFileExtListEmpty = true;
        if (assoc.getFileExtList() != null) {
            isFileExtListEmpty = assoc.getFileExtList().isEmpty();
        }
        if (assoc.getMimeType() == null && isFileExtListEmpty) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    public boolean isAssociationExist(Association assoc, int regLevel) {
        String temFileExt = null;
        String temMimeType = assoc.getMimeType();
        Iterator temFileExtIter = assoc.getFileExtList() != null ? assoc.getFileExtList().iterator() : null;
        if (temFileExtIter != null && temFileExtIter.hasNext()) {
            temFileExt = (String)temFileExtIter.next();
        }
        if (WinRegistryUtil.isWin2kUserDefinedFileExtExist(temFileExt)) {
            return true;
        }
        if (temMimeType == null && temFileExt == null) {
            return false;
        }
        if (temMimeType == null && temFileExt != null) {
            return WinRegistryUtil.isFileExtExist(temFileExt, regLevel);
        }
        if (temMimeType != null && temFileExt == null) {
            return WinRegistryUtil.isMimeTypeExist(temMimeType, regLevel);
        }
        String regMimeType = WinRegistryUtil.getMimeTypeByFileExt(temFileExt, regLevel);
        String regFileExt = WinRegistryUtil.getFileExtByMimeType(temMimeType, regLevel);
        return WinRegistryUtil.isMimeTypeExist(temMimeType, regLevel) && WinRegistryUtil.isFileExtExist(temFileExt, regLevel) && (temFileExt == null ? regFileExt == null : temFileExt.equals(regFileExt)) && (temMimeType == null ? regMimeType == null : temMimeType.equals(regMimeType));
    }

    public void registerAssociation(Association assoc, int regLevel) throws RegisterFailedException {
        boolean isOldWindows = false;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("98") != -1 || osName.indexOf("me") != -1 || osName.indexOf("nt") != -1) {
            isOldWindows = true;
        }
        if (isOldWindows) {
            regLevel = 2;
        }
        BackupAssociation backupAssoc = new BackupAssociation(assoc, regLevel);
        String curMimeType = backupAssoc.getCurMimeType();
        String curFileExt = backupAssoc.getCurFileExt();
        String curDescription = assoc.getDescription();
        String curIconFileName = assoc.getIconFileName();
        List curActionList = assoc.getActionList();
        boolean curMimeTypeExisted = backupAssoc.getCurMimeTypeExisted();
        boolean curFileExtExisted = backupAssoc.getCurFileExtExisted();
        try {
            if (curMimeType == null && curFileExt != null) {
                WinRegistryUtil.addFileExt(curFileExt, regLevel);
                if (curDescription != null) {
                    WinRegistryUtil.setDescriptionByFileExt(curDescription, curFileExt, regLevel);
                }
                if (curIconFileName != null) {
                    WinRegistryUtil.setIconFileNameByFileExt(curIconFileName, curFileExt, regLevel);
                }
                if (curActionList != null) {
                    WinRegistryUtil.setActionListByFileExt(curActionList, curFileExt, regLevel);
                }
                WinRegistryUtil.markGeneratorByFileExt(curFileExt, regLevel);
            } else if (curMimeType != null && curFileExt == null) {
                WinRegistryUtil.addMimeType(curMimeType, regLevel);
            } else if (curMimeType != null && curFileExt != null) {
                if (!curMimeTypeExisted) {
                    WinRegistryUtil.addMimeType(curMimeType, regLevel);
                }
                if (!curFileExtExisted) {
                    WinRegistryUtil.addFileExt(curFileExt, regLevel);
                }
                if (curDescription != null) {
                    WinRegistryUtil.setDescriptionByFileExt(curDescription, curFileExt, regLevel);
                }
                if (curIconFileName != null) {
                    WinRegistryUtil.setIconFileNameByFileExt(curIconFileName, curFileExt, regLevel);
                }
                if (curActionList != null) {
                    WinRegistryUtil.setActionListByFileExt(curActionList, curFileExt, regLevel);
                }
                WinRegistryUtil.markGeneratorByFileExt(curFileExt, regLevel);
                WinRegistryUtil.setMutualRef(curFileExt, curMimeType, regLevel);
            }
        }
        catch (RegisterFailedException e) {
            this.restoreAssociationRegistration(backupAssoc, regLevel);
            throw e;
        }
    }

    public void unregisterAssociation(Association assoc, int regLevel) throws RegisterFailedException {
        boolean isOldWindows = false;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("98") != -1 || osName.indexOf("me") != -1 || osName.indexOf("nt") != -1) {
            isOldWindows = true;
        }
        if (isOldWindows) {
            regLevel = 2;
        }
        BackupAssociation backupAssoc = new BackupAssociation(assoc, regLevel);
        String curMimeType = backupAssoc.getCurMimeType();
        String curFileExt = backupAssoc.getCurFileExt();
        boolean curMimeTypeExisted = backupAssoc.getCurMimeTypeExisted();
        boolean curFileExtExisted = backupAssoc.getCurFileExtExisted();
        try {
            if (curMimeTypeExisted) {
                WinRegistryUtil.removeMimeType(curMimeType, regLevel);
            }
            if (curFileExtExisted) {
                WinRegistryUtil.removeFileExt(curFileExt, regLevel);
            }
        }
        catch (RegisterFailedException e) {
            this.restoreAssociationUnregistration(backupAssoc, regLevel);
            throw e;
        }
    }

    protected class BackupAssociation {
        private String curMimeType;
        private String curFileExt;
        private boolean curMimeTypeExisted;
        private boolean curFileExtExisted;
        private String backupMimeType;
        private String backupClassID;
        private String backupFileExt;

        private BackupAssociation() {
        }

        protected BackupAssociation(Association assoc, int regLevel) {
            this.curMimeType = assoc.getMimeType();
            Iterator iter = null;
            List temFileExtList = assoc.getFileExtList();
            if (temFileExtList != null) {
                iter = temFileExtList.iterator();
            }
            if (iter != null && iter.hasNext()) {
                this.curFileExt = (String)iter.next();
            }
            this.curMimeTypeExisted = this.curMimeType != null ? WinRegistryUtil.isMimeTypeExist(this.curMimeType, regLevel) : false;
            this.curFileExtExisted = this.curFileExt != null ? WinRegistryUtil.isFileExtExist(this.curFileExt, regLevel) : false;
            if (this.curMimeTypeExisted) {
                this.backupFileExt = WinRegistryUtil.getFileExtByMimeType(this.curMimeType, regLevel);
            }
            if (this.curFileExtExisted) {
                this.backupClassID = WinRegistryUtil.getClassIDByFileExt(this.curFileExt, regLevel);
                this.backupMimeType = WinRegistryUtil.getMimeTypeByFileExt(this.curFileExt, regLevel);
            }
        }

        protected String getCurMimeType() {
            return this.curMimeType;
        }

        protected String getCurFileExt() {
            return this.curFileExt;
        }

        protected boolean getCurMimeTypeExisted() {
            return this.curMimeTypeExisted;
        }

        protected boolean getCurFileExtExisted() {
            return this.curFileExtExisted;
        }

        protected String getBackupMimeType() {
            return this.backupMimeType;
        }

        protected String getBackupClassID() {
            return this.backupClassID;
        }

        protected String getBackupFileExt() {
            return this.backupFileExt;
        }
    }
}

