/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.text.DecimalFormat;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;

public class StandardTickUnitSource
implements TickUnitSource {
    private static final double LOG_10_VALUE = Math.log(10.0);

    public TickUnit getLargerTickUnit(TickUnit tickUnit) {
        double d = tickUnit.getSize();
        double d2 = Math.log(d) / LOG_10_VALUE;
        double d3 = Math.ceil(d2);
        return new NumberTickUnit(Math.pow(10.0, d3), new DecimalFormat("0.0E0"));
    }

    public TickUnit getCeilingTickUnit(TickUnit tickUnit) {
        return this.getLargerTickUnit(tickUnit);
    }

    public TickUnit getCeilingTickUnit(double d) {
        double d2 = Math.log(d) / LOG_10_VALUE;
        double d3 = Math.ceil(d2);
        return new NumberTickUnit(Math.pow(10.0, d3), new DecimalFormat("0.0E0"));
    }
}

