/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ArrayUtils;
import org.jfree.util.ObjectUtils;

public class FastScatterPlot
extends Plot
implements ValueAxisPlot,
Cloneable,
Serializable {
    private float[][] data;
    private Range xDataRange;
    private Range yDataRange;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private transient Paint paint;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public FastScatterPlot() {
        this(null, null, null);
    }

    public FastScatterPlot(float[][] fArray, ValueAxis valueAxis, ValueAxis valueAxis2) {
        this.data = fArray;
        this.xDataRange = this.calculateXDataRange(fArray);
        this.yDataRange = this.calculateYDataRange(fArray);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.paint = Color.red;
    }

    public String getPlotType() {
        return localizationResources.getString("Fast_Scatter_Plot");
    }

    public ValueAxis getDomainAxis() {
        return this.domainAxis;
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        double d;
        Insets insets;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.BOTTOM, axisSpace);
        axisSpace = this.rangeAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.LEFT, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        if (this.domainAxis != null) {
            d = rectangle2D2.getMaxY();
            object = this.domainAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM);
            d = ((AxisState)object).getCursor();
        }
        if (this.rangeAxis != null) {
            d = rectangle2D2.getMinX();
            object = this.rangeAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT);
            d = ((AxisState)object).getCursor();
        }
        object = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.render(graphics2D, rectangle2D2, plotRenderingInfo, null);
        graphics2D.setClip((Shape)object);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, CrosshairInfo crosshairInfo) {
        graphics2D.setPaint(Color.red);
        if (this.data != null) {
            for (int i = 0; i < this.data[0].length; ++i) {
                float f = this.data[0][i];
                float f2 = this.data[1][i];
                int n = (int)this.domainAxis.translateValueToJava2D(f, rectangle2D, RectangleEdge.BOTTOM);
                int n2 = (int)this.rangeAxis.translateValueToJava2D(f2, rectangle2D, RectangleEdge.LEFT);
                graphics2D.fillRect(n, n2, 1, 1);
            }
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (valueAxis == this.domainAxis) {
            range = this.xDataRange;
        } else if (valueAxis == this.rangeAxis) {
            range = this.yDataRange;
        }
        return range;
    }

    private Range calculateXDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < fArray[0].length; ++i) {
                float f3 = fArray[0][i];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            if (f <= f2) {
                range = new Range(f, f2);
            }
        }
        return range;
    }

    private Range calculateYDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < fArray[0].length; ++i) {
                float f3 = fArray[1][i];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            if (f <= f2) {
                range = new Range(f, f2);
            }
        }
        return range;
    }

    public void zoomHorizontalAxes(double d) {
        this.domainAxis.resizeRange(d);
    }

    public void zoomHorizontalAxes(double d, double d2) {
        this.domainAxis.zoomRange(d, d2);
    }

    public void zoomVerticalAxes(double d) {
        this.rangeAxis.resizeRange(d);
    }

    public void zoomVerticalAxes(double d, double d2) {
        this.rangeAxis.zoomRange(d, d2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof FastScatterPlot) {
            FastScatterPlot fastScatterPlot = (FastScatterPlot)object;
            boolean bl = ArrayUtils.equal((float[][])this.data, (float[][])fastScatterPlot.data);
            boolean bl2 = ObjectUtils.equal((Object)this.domainAxis, (Object)fastScatterPlot.domainAxis);
            boolean bl3 = ObjectUtils.equal((Object)this.rangeAxis, (Object)fastScatterPlot.rangeAxis);
            boolean bl4 = ObjectUtils.equal((Object)this.paint, (Object)fastScatterPlot.paint);
            return bl && bl2 && bl3 && bl4;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        FastScatterPlot fastScatterPlot = (FastScatterPlot)super.clone();
        if (this.data != null) {
            fastScatterPlot.data = ArrayUtils.clone((float[][])this.data);
        }
        if (this.domainAxis != null) {
            fastScatterPlot.domainAxis = (ValueAxis)this.domainAxis.clone();
            fastScatterPlot.domainAxis.setPlot(fastScatterPlot);
            fastScatterPlot.domainAxis.addChangeListener(fastScatterPlot);
        }
        if (this.rangeAxis != null) {
            fastScatterPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            fastScatterPlot.rangeAxis.setPlot(fastScatterPlot);
            fastScatterPlot.rangeAxis.addChangeListener(fastScatterPlot);
        }
        return fastScatterPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.addChangeListener(this);
        }
    }
}

