/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

public class Statistics {
    public static double getAverage(Number[] numberArray) {
        int n;
        double d = 0.0;
        for (n = 0; n < numberArray.length; ++n) {
            d += numberArray[n].doubleValue();
        }
        return d / (double)n;
    }

    public static double getStdDev(Number[] numberArray) {
        int n;
        double d = Statistics.getAverage(numberArray);
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < numberArray.length; ++n) {
            d3 = numberArray[n].doubleValue() - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(n - 1));
    }

    public static double[] getLinearFit(Number[] numberArray, Number[] numberArray2) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getLinearFit(...): array lengths must be equal.");
        }
        double[] dArray = new double[2];
        dArray[1] = Statistics.getSlope(numberArray, numberArray2);
        dArray[0] = Statistics.getAverage(numberArray2) - dArray[1] * Statistics.getAverage(numberArray);
        return dArray;
    }

    public static double getSlope(Number[] numberArray, Number[] numberArray2) {
        int n;
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getSlope(...): array lengths must be equal.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < numberArray.length; ++n) {
            d += numberArray[n].doubleValue();
            d2 += Math.pow(numberArray[n].doubleValue(), 2.0);
            d3 += numberArray2[n].doubleValue() * numberArray[n].doubleValue();
            d4 += numberArray2[n].doubleValue();
        }
        return (d3 - d * d4 / (double)n) / (d2 - d * d / (double)n);
    }

    public static double getCorrelation(Number[] numberArray, Number[] numberArray2) {
        int n;
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getCorrelation(...): array lengths must be equal.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        Number[] numberArray3 = new Double[numberArray.length];
        Number[] numberArray4 = new Double[numberArray2.length];
        for (n = 0; n < numberArray.length; ++n) {
            numberArray3[n] = new Double(numberArray[n].doubleValue());
        }
        for (n = 0; n < numberArray2.length; ++n) {
            numberArray4[n] = new Double(numberArray2[n].doubleValue());
        }
        d = Statistics.getAverage(numberArray3);
        d2 = Statistics.getAverage(numberArray4);
        d3 = Statistics.getStdDev(numberArray3);
        d4 = Statistics.getStdDev(numberArray4);
        while (n2 < numberArray3.length) {
            numberArray3[n2] = new Double((numberArray3[n2].doubleValue() - d) / d3);
            numberArray4[n2] = new Double((numberArray4[n2].doubleValue() - d2) / d4);
            ++n2;
        }
        for (n2 = 0; n2 < numberArray3.length; ++n2) {
            numberArray3[n2] = new Double(numberArray3[n2].doubleValue() * numberArray4[n2].doubleValue());
        }
        return Statistics.getAverage(numberArray3);
    }

    public static double[][] getMovingAverage(Number[] numberArray, Number[] numberArray2, int n) {
        if (numberArray.length != numberArray2.length) {
            throw new IllegalArgumentException("Statistics.getMovingAverage(...): array lengths must be equal.");
        }
        if (n > numberArray.length) {
            throw new IllegalArgumentException("Statistics.getMovingAverage(...): period can't be longer than dataset.");
        }
        double[][] dArray = new double[numberArray.length - n][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][0] = numberArray[i + n].doubleValue();
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += numberArray2[i + j].doubleValue();
            }
            dArray[i][1] = d /= (double)n;
        }
        return dArray;
    }
}

