/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityComment
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -4767165400814896586L;
    public String id;
    public String ownerId;
    public String ownerName;
    public String content;
    public Date published;
    public String replyCommentId;
    public String replyUserId;

    ActivityComment(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.published = new Date(json.getLong("sendTime"));
            this.ownerId = json.getString("ownerId");
            this.ownerName = json.getString("ownerName");
            this.replyCommentId = json.getString("commentId");
            this.replyUserId = json.getString("repliedOwnerId");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    ActivityComment(JSONObject json) throws WeiboException {
        try {
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.published = new Date(json.getLong("sendTime"));
            this.ownerId = json.getString("ownerId");
            this.ownerName = json.getString("ownerName");
            this.replyCommentId = json.getString("commentId");
            this.replyUserId = json.getString("repliedOwnerId");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<ActivityComment> constructList(JSONArray commentsJsonList) throws WeiboException, JSONException {
        if (commentsJsonList != null) {
            int size = commentsJsonList.length();
            ArrayList<ActivityComment> comments = new ArrayList<ActivityComment>(size);
            int i = 0;
            while (i < size) {
                comments.add(new ActivityComment(commentsJsonList.getJSONObject(i)));
                ++i;
            }
            return comments;
        }
        return null;
    }
}

