/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.RetweetDetails;
import kdweibo4j.User;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment
extends WeiboResponse
implements Serializable {
    private Date createdAt;
    private String id;
    private String text;
    private String source;
    private boolean isTruncated;
    private String inReplyToStatusId;
    private String inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private String inReplyToCommentText;
    private RetweetDetails retweetDetails;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Comment(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Comment(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getString("id");
        this.text = json.getString("text");
        System.out.println("...comment...." + this.text);
        this.source = json.getString("source");
        this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!json.isNull("user")) {
            this.user = new User(json.getJSONObject("user"));
        }
    }

    public Comment(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.id = json.getString("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Comment.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.user = new User(json.getJSONObject("user"));
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public String getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isRetweet() {
        return this.retweetDetails != null;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Comment> constructComments(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Comment> comments = new ArrayList<Comment>(size);
            int i = 0;
            while (i < size) {
                System.out.println("........constructComments........." + list.getJSONObject(i).toString());
                comments.add(new Comment(list.getJSONObject(i)));
                ++i;
            }
            for (Comment comment : comments) {
                System.out.println("........comments text........." + comment.getText());
            }
            return comments;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Comment && ((Comment)obj).id == this.id;
    }

    public String toString() {
        return "Comment{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", retweetDetails=" + this.retweetDetails + ", user=" + this.user + '}';
    }
}

