/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.User;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessage
extends WeiboResponse
implements Serializable {
    private String id;
    private String text;
    private String sender_id;
    private String recipient_id;
    private Date created_at;
    private String sender_screen_name;
    private String recipient_screen_name;
    private static final long serialVersionUID = -3253021825891789737L;
    private User sender;
    private User recipient;

    DirectMessage(JSONObject json) throws WeiboException {
        try {
            this.id = json.getString("id");
            this.text = json.getString("text");
            this.sender_id = json.getString("sender_id");
            this.recipient_id = json.getString("recipient_id");
            this.created_at = DirectMessage.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.sender_screen_name = json.getString("sender_screen_name");
            this.recipient_screen_name = json.getString("recipient_screen_name");
            if (!json.isNull("sender")) {
                this.sender = new User(json.getJSONObject("sender"));
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(String.valueOf(jsone.getMessage()) + ":" + json.toString(), jsone);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSenderId() {
        return this.sender_id;
    }

    public String getRecipientId() {
        return this.recipient_id;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public String getSenderScreenName() {
        return this.sender_screen_name;
    }

    public String getRecipientScreenName() {
        return this.recipient_screen_name;
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    static List<DirectMessage> constructDirectMessages(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>(size);
            int i = 0;
            while (i < size) {
                messages.add(new DirectMessage(list.getJSONObject(i)));
                ++i;
            }
            return messages;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof DirectMessage && ((DirectMessage)obj).id == this.id;
    }

    public String toString() {
        return "DirectMessage{id=" + this.id + ", text='" + this.text + '\'' + ", sender_id=" + this.sender_id + ", recipient_id=" + this.recipient_id + ", created_at=" + this.created_at + ", sender_screen_name='" + this.sender_screen_name + '\'' + ", recipient_screen_name='" + this.recipient_screen_name + '\'' + ", sender=" + this.sender + ", recipient=" + this.recipient + '}';
    }
}

