/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.Activity;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4797674664272323011L;
    public String targetId;
    public String category;
    public String title;
    public String digest;
    public String conversationState;
    public int unread;
    public Date createDate;
    public long itemCount;
    public long subscriberCount;
    public String tagKey;
    public long participantCount;
    public List<String> userList;
    public List<Activity> activityList;
    public boolean subscribe;
    public boolean participate;

    Feed(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONArray atcivityListJsonArr;
            JSONObject meta;
            this.targetId = json.getString("feedSource");
            this.title = json.getString("title");
            this.unread = json.getInt("unread");
            this.tagKey = json.getString("tagKey");
            this.createDate = new Date(json.getLong("createDate"));
            this.subscribe = json.getBoolean("subscribe");
            this.participate = json.getBoolean("participate");
            JSONObject statisticsJson = json.getJSONObject("statistics");
            if (statisticsJson != null) {
                this.itemCount = statisticsJson.getLong("itemCount");
                this.subscriberCount = statisticsJson.getLong("subscriberCount");
                this.participantCount = statisticsJson.getLong("participantCount");
            }
            if ((meta = json.getJSONObject("metas")) != null) {
                this.category = meta.getString("category");
                this.conversationState = meta.getString("conversationState");
            }
            if (!json.get("activityList").toString().equals("null") && (atcivityListJsonArr = json.getJSONArray("activityList")) != null) {
                ArrayList<Activity> list = new ArrayList<Activity>();
                int length = atcivityListJsonArr.length();
                int i = 0;
                while (i < length) {
                    JSONObject activityJson = atcivityListJsonArr.getJSONObject(i);
                    if (activityJson != null) {
                        Activity act = new Activity(activityJson);
                        list.add(act);
                    }
                    ++i;
                }
                this.activityList = list;
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    Feed(JSONObject json) throws WeiboException {
        try {
            JSONArray atcivityListJsonArr;
            JSONObject meta;
            this.targetId = json.getString("feedSource");
            this.title = json.getString("title");
            this.unread = json.getInt("unread");
            this.tagKey = json.getString("tagKey");
            this.createDate = new Date(json.getLong("createDate"));
            this.subscribe = json.getBoolean("subscribe");
            this.participate = json.getBoolean("participate");
            JSONObject statisticsJson = json.getJSONObject("statistics");
            if (statisticsJson != null) {
                this.itemCount = statisticsJson.getLong("itemCount");
                this.subscriberCount = statisticsJson.getLong("subscriberCount");
                this.participantCount = statisticsJson.getLong("participantCount");
            }
            if ((meta = json.getJSONObject("metas")) != null) {
                this.category = meta.getString("category");
                this.conversationState = meta.getString("conversationState");
            }
            if (!json.get("activityList").toString().equals("null") && (atcivityListJsonArr = json.getJSONArray("activityList")) != null) {
                ArrayList<Activity> list = new ArrayList<Activity>();
                int length = atcivityListJsonArr.length();
                int i = 0;
                while (i < length) {
                    JSONObject activityJson = atcivityListJsonArr.getJSONObject(i);
                    if (activityJson != null) {
                        Activity act = new Activity(activityJson);
                        list.add(act);
                    }
                    ++i;
                }
                this.activityList = list;
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    static List<Feed> constructList(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<Feed> feeds = new ArrayList<Feed>(size);
            int i = 0;
            while (i < size) {
                feeds.add(new Feed(list.getJSONObject(i)));
                ++i;
            }
            return feeds;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + list.toString(), je);
        }
    }
}

