/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.util.ArrayList;
import java.util.List;
import kdweibo4j.http.PostParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private String query = null;
    private String lang = null;
    private int rpp = -1;
    private int page = -1;
    private long sinceId = -1L;
    private String geocode = null;
    public static final String MILES = "mi";
    public static final String KILOMETERS = "km";

    public Query() {
    }

    public Query(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public int getRpp() {
        return this.rpp;
    }

    public void setRpp(int rpp) {
        this.rpp = rpp;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public String getGeocode() {
        return this.geocode;
    }

    public void setGeoCode(double latitude, double longtitude, double radius, String unit) {
        this.geocode = String.valueOf(latitude) + "," + longtitude + "," + radius + unit;
    }

    public PostParameter[] asPostParameters() {
        ArrayList<PostParameter> params = new ArrayList<PostParameter>();
        this.appendParameter("q", this.query, params);
        this.appendParameter("lang", this.lang, params);
        this.appendParameter("rpp", this.rpp, params);
        this.appendParameter("page", this.page, params);
        this.appendParameter("since_id", this.sinceId, params);
        this.appendParameter("geocode", this.geocode, params);
        PostParameter[] paramArray = new PostParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<PostParameter> params) {
        if (value != null) {
            params.add(new PostParameter(name, value));
        }
    }

    private void appendParameter(String name, long value, List<PostParameter> params) {
        if (0L <= value) {
            params.add(new PostParameter(name, String.valueOf(value)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.page != query1.page) {
            return false;
        }
        if (this.rpp != query1.rpp) {
            return false;
        }
        if (this.sinceId != query1.sinceId) {
            return false;
        }
        if (this.geocode != null ? !this.geocode.equals(query1.geocode) : query1.geocode != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(query1.lang) : query1.lang != null) {
            return false;
        }
        return !(this.query != null ? !this.query.equals(query1.query) : query1.query != null);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + this.rpp;
        result = 31 * result + this.page;
        result = 31 * result + (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (this.geocode != null ? this.geocode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", lang='" + this.lang + '\'' + ", rpp=" + this.rpp + ", page=" + this.page + ", sinceId=" + this.sinceId + ", geocode='" + this.geocode + '\'' + '}';
    }
}

