/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kdweibo4j.Attachment;
import kdweibo4j.Picture;
import kdweibo4j.RetweetDetails;
import kdweibo4j.User;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboResponse;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 1608000492860584608L;
    private Date createdAt;
    private Date updateAt;
    private String id;
    private String text;
    private String source;
    private boolean isTruncated;
    private String inReplyToStatusId;
    private String inReplyToUserId;
    private boolean isFavorited;
    private boolean isLiked;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private String location = "";
    private String thumbnail_pic;
    private String bmiddle_pic;
    private String original_pic;
    private RetweetDetails retweetDetails;
    private User user = null;
    private List<Attachment> attachmentList = new ArrayList<Attachment>();
    public List<Picture> pictures = new ArrayList<Picture>();

    Status(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.latitude = json.getDouble("latitude");
            this.longitude = json.getDouble("longitude");
            this.location = json.getString("address");
            this.inReplyToStatusId = json.getString("in_reply_to_status_id");
            this.inReplyToUserId = json.getString("in_reply_to_user_id");
            this.isFavorited = Status.getBoolean("favorited", json);
            this.isLiked = Status.getBoolean("liked", json);
            this.thumbnail_pic = json.getString("thumbnail_pic");
            this.bmiddle_pic = json.getString("bmiddle_pic");
            this.original_pic = json.getString("original_pic");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            this.inReplyToScreenName = json.getString("inReplyToScreenName");
            if (!json.isNull("retweeted_status")) {
                this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
            }
            this.setPictures(json);
            this.setAttachments(json);
            System.out.println(".........Status........" + this.latitude + "|" + this.longitude + "|" + this.location + "|JSON|" + json.toString());
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean isLiked() {
        return this.isLiked;
    }

    public void setLiked(boolean isLiked) {
        this.isLiked = isLiked;
    }

    public Status(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getString("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.updateAt = Status.parseDate(json.getString("update_at"), "EEE MMM dd HH:mm:ss.SSS z yyyy");
        this.isFavorited = Status.getBoolean("favorited", json);
        this.isTruncated = Status.getBoolean("truncated", json);
        this.isLiked = Status.getBoolean("liked", json);
        this.inReplyToStatusId = json.getString("in_reply_to_status_id");
        this.inReplyToUserId = json.getString("in_reply_to_user_id");
        this.inReplyToScreenName = json.getString("in_reply_to_screen_name");
        this.thumbnail_pic = json.getString("thumbnail_pic");
        this.bmiddle_pic = json.getString("bmiddle_pic");
        this.original_pic = json.getString("original_pic");
        this.user = new User(json.getJSONObject("user"));
        if (!json.isNull("retweeted_status")) {
            this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
        }
        this.setPictures(json);
        this.setAttachments(json);
    }

    public Status(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.id = json.getString("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.updateAt = Status.parseDate(json.getString("update_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.inReplyToStatusId = json.getString("in_reply_to_status_id");
        this.inReplyToUserId = json.getString("in_reply_to_user_id");
        this.isFavorited = Status.getBoolean("favorited", json);
        this.isLiked = Status.getBoolean("liked", json);
        this.thumbnail_pic = json.getString("thumbnail_pic");
        this.bmiddle_pic = json.getString("bmiddle_pic");
        this.original_pic = json.getString("original_pic");
        this.user = new User(json.getJSONObject("user"));
        if (!json.isNull("retweeted_status")) {
            this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
        }
        this.setPictures(json);
        this.setAttachments(json);
    }

    private void setPictures(JSONObject json) throws WeiboException, JSONException {
        JSONArray pics = null;
        try {
            pics = json.getJSONArray("pictures");
        }
        catch (Exception e) {
            pics = null;
        }
        if (pics != null) {
            int size = pics.length();
            Picture pic = null;
            int i = 0;
            while (i < size) {
                pic = new Picture(pics.getJSONObject(i));
                this.pictures.add(pic);
                ++i;
            }
        }
    }

    private void setAttachments(JSONObject json) throws WeiboException, JSONException {
        JSONArray atm = null;
        try {
            atm = json.getJSONArray("attachment");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (atm != null) {
            int size = atm.length();
            Attachment attam = null;
            int i = 0;
            while (i < size) {
                attam = new Attachment(atm.getJSONObject(i));
                this.attachmentList.add(attam);
                ++i;
            }
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public String getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public String getThumbnail_pic() {
        return this.thumbnail_pic;
    }

    public String getBmiddle_pic() {
        return this.bmiddle_pic;
    }

    public String getOriginal_pic() {
        return this.original_pic;
    }

    public User getUser() {
        return this.user;
    }

    public void setAttachmentList(List<Attachment> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public List<Attachment> getAttachmentList() {
        return this.attachmentList;
    }

    public boolean isRetweet() {
        return this.retweetDetails != null;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Status> constructStatuses(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            int i = 0;
            while (i < size) {
                statuses.add(new Status(list.getJSONObject(i)));
                ++i;
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).id == this.id;
    }

    public Date getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
    }

    public String toString() {
        return "Status{createdAt=" + this.createdAt + ",updateAt=" + this.updateAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", thumbnail_pic=" + this.thumbnail_pic + ", bmiddle_pic=" + this.bmiddle_pic + ", original_pic=" + this.original_pic + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", retweetDetails=" + this.retweetDetails + ", user=" + this.user + '}';
    }
}

