/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kdweibo4j.Activity;
import kdweibo4j.ActivityComment;
import kdweibo4j.Attachment;
import kdweibo4j.Comment;
import kdweibo4j.Configuration;
import kdweibo4j.Count;
import kdweibo4j.DirectMessage;
import kdweibo4j.Feed;
import kdweibo4j.Group;
import kdweibo4j.IDs;
import kdweibo4j.Paging;
import kdweibo4j.RateLimitStatus;
import kdweibo4j.RetweetDetails;
import kdweibo4j.Status;
import kdweibo4j.Tag;
import kdweibo4j.Trends;
import kdweibo4j.User;
import kdweibo4j.UserAndToken;
import kdweibo4j.UserTokenList;
import kdweibo4j.UserWapper;
import kdweibo4j.WeiboException;
import kdweibo4j.WeiboSupport;
import kdweibo4j.http.AccessToken;
import kdweibo4j.http.HttpClient;
import kdweibo4j.http.ImageItem;
import kdweibo4j.http.PostParameter;
import kdweibo4j.http.RequestToken;
import kdweibo4j.http.Response;
import kdweibo4j.org.json.JSONArray;
import kdweibo4j.org.json.JSONException;
import kdweibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weibo
extends WeiboSupport
implements Serializable {
    public String CONSUMER_KEY = "";
    public String CONSUMER_SECRET = "";
    private String host = "kdweibo.com";
    private String baseURL = String.valueOf(Configuration.getScheme()) + this.host + "/snsapi/";
    private String searchBaseURL = String.valueOf(Configuration.getScheme()) + this.host + "/snsapi/";
    private static final long serialVersionUID = -1486360080128882436L;
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public Weibo() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setHost(this.host);
    }

    public void setHost(String host) {
        this.host = host;
        this.http.setRequestTokenURL(String.valueOf(Configuration.getScheme()) + host + "/snsapi/oauth/request_token");
        this.http.setAuthorizationURL(String.valueOf(Configuration.getScheme()) + host + "/snsapi/oauth/authorize");
        this.http.setAccessTokenURL(String.valueOf(Configuration.getScheme()) + host + "/snsapi/oauth/access_token");
        this.baseURL = String.valueOf(Configuration.getScheme()) + host + "/snsapi/";
        this.searchBaseURL = String.valueOf(Configuration.getScheme()) + host + "/snsapi/";
    }

    public void setToken(String token, String tokenSecret) {
        this.http.setToken(token, tokenSecret);
    }

    public Weibo(String baseURL) {
        this();
        this.baseURL = baseURL;
    }

    public Weibo(String id, String password) {
        this();
        this.setUserId(id);
        this.setPassword(password);
    }

    public Weibo(String id, String password, String baseURL) {
        this();
        this.setUserId(id);
        this.setPassword(password);
        this.baseURL = baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.CONSUMER_KEY = consumerKey;
        this.CONSUMER_SECRET = consumerSecret;
        this.http.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws WeiboException {
        return this.http.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callback_url) throws WeiboException {
        return this.http.getOauthRequestToken(callback_url);
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws WeiboException {
        return this.http.getOAuthAccessToken(requestToken);
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String pin) throws WeiboException {
        AccessToken accessToken = this.http.getOAuthAccessToken(requestToken, pin);
        this.setUserId(accessToken.getScreenName());
        return accessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret) throws WeiboException {
        AccessToken accessToken = this.http.getOAuthAccessToken(token, tokenSecret);
        this.setUserId(accessToken.getScreenName());
        return accessToken;
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret, String oauth_verifier) throws WeiboException {
        return this.http.getOAuthAccessToken(token, tokenSecret, oauth_verifier);
    }

    public synchronized AccessToken getXAuthAccessToken(String userId, String passWord, String mode) throws WeiboException {
        return this.http.getXAuthAccessToken(userId, passWord, mode);
    }

    public synchronized AccessToken getAppAuthAccessToken() throws WeiboException {
        return this.http.getAPPAuthAccessToken();
    }

    public synchronized AccessToken getAccessTokenByLoginToken(String userId, String loginToken) throws WeiboException {
        return this.http.getAccessTokenByLoginToken(userId, loginToken);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.http.setOAuthAccessToken(accessToken);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.setOAuthAccessToken(new AccessToken(token, tokenSecret));
    }

    private Response get(String url, boolean authenticate) throws WeiboException {
        return this.get(url, null, authenticate);
    }

    protected Response get(String url, String name1, String value1, boolean authenticate) throws WeiboException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1)}, authenticate);
    }

    protected Response get(String url, String name1, String value1, String name2, String value2, boolean authenticate) throws WeiboException {
        return this.get(url, new PostParameter[]{new PostParameter(name1, value1), new PostParameter(name2, value2)}, authenticate);
    }

    protected Response get(String url, PostParameter[] params, boolean authenticate) throws WeiboException {
        if (url.indexOf("?") == -1) {
            url = String.valueOf(url) + "?source=" + this.CONSUMER_KEY;
        } else if (url.indexOf("source") == -1) {
            url = String.valueOf(url) + "&source=" + this.CONSUMER_KEY;
        }
        if (authenticate && this.getUserId() != null) {
            try {
                url = String.valueOf(url) + "&xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (params != null && params.length > 0) {
            url = String.valueOf(url) + "&" + HttpClient.encodeParameters(params);
        }
        return this.http.get(url, authenticate);
    }

    protected Response get(String url, PostParameter[] params, Paging paging, boolean authenticate) throws WeiboException {
        if (paging != null) {
            ArrayList<PostParameter> pagingParams = new ArrayList<PostParameter>(4);
            if (paging.getMaxId() != null) {
                pagingParams.add(new PostParameter("max_id", String.valueOf(paging.getMaxId())));
            }
            if (paging.getSinceId() != null) {
                pagingParams.add(new PostParameter("since_id", String.valueOf(paging.getSinceId())));
            }
            if (-1 != paging.getPage()) {
                pagingParams.add(new PostParameter("page", String.valueOf(paging.getPage())));
            }
            if (-1 != paging.getCount()) {
                if (-1 != url.indexOf("search")) {
                    pagingParams.add(new PostParameter("rpp", String.valueOf(paging.getCount())));
                } else {
                    pagingParams.add(new PostParameter("count", String.valueOf(paging.getCount())));
                }
            }
            PostParameter[] newparams = null;
            PostParameter[] arrayPagingParams = pagingParams.toArray(new PostParameter[pagingParams.size()]);
            if (params != null) {
                newparams = new PostParameter[params.length + pagingParams.size()];
                System.arraycopy(params, 0, newparams, 0, params.length);
                System.arraycopy(arrayPagingParams, 0, newparams, params.length, pagingParams.size());
            } else if (arrayPagingParams.length != 0) {
                String encodedParams = HttpClient.encodeParameters(arrayPagingParams);
                url = -1 != url.indexOf("?") ? String.valueOf(url) + "&source=" + this.CONSUMER_KEY + "&" + encodedParams : String.valueOf(url) + "?source=" + this.CONSUMER_KEY + "&" + encodedParams;
            }
            return this.get(url, newparams, authenticate);
        }
        return this.get(url, params, authenticate);
    }

    public List<Status> search(String q) throws WeiboException {
        return Status.constructStatuses(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/search.json?source=" + this.CONSUMER_KEY + "&q=" + q, true));
    }

    public Trends getTrends() throws WeiboException {
        return Trends.constructTrends(this.get(String.valueOf(this.searchBaseURL) + "trends.json", true));
    }

    public Trends getCurrentTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/current.json", true)).get(0);
    }

    public Trends getCurrentTrends(boolean excludeHashTags) throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/current.json" + (excludeHashTags ? "?exclude=hashtags" : ""), true)).get(0);
    }

    public List<Trends> getDailyTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/daily.json", true));
    }

    public List<Trends> getDailyTrends(Date date, boolean excludeHashTags) throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/daily.json?date=" + this.toDateStr(date) + (excludeHashTags ? "&exclude=hashtags" : ""), true));
    }

    private String toDateStr(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public List<Trends> getWeeklyTrends() throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/weekly.json", false));
    }

    public List<Trends> getWeeklyTrends(Date date, boolean excludeHashTags) throws WeiboException {
        return Trends.constructTrendsList(this.get(String.valueOf(this.searchBaseURL) + "trends/weekly.json?date=" + this.toDateStr(date) + (excludeHashTags ? "&exclude=hashtags" : ""), false));
    }

    public List<Status> getPublicTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/public_timeline.json", true));
    }

    public RateLimitStatus getRateLimitStatus() throws WeiboException {
        return new RateLimitStatus(this.get(String.valueOf(this.getBaseURL()) + "account/rate_limit_status.json", true), this);
    }

    public List<Status> getPublicTimeline(String sinceID) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/public_timeline.json", null, new Paging(sinceID), false));
    }

    public List<Status> getHomeTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/home_timeline.json", true));
    }

    public List<Status> getHomeTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/home_timeline.json", null, paging, true));
    }

    public List<Status> getFriendsTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends_timeline.json", true));
    }

    public List<Status> getFriendsTimelineByPage(int page) throws WeiboException {
        return this.getFriendsTimeline(new Paging(page));
    }

    public List<Status> getFriendsTimeline(int page) throws WeiboException {
        return this.getFriendsTimeline(new Paging(page));
    }

    public List<Status> getFriendsTimeline(String sinceId, int page) throws WeiboException {
        return this.getFriendsTimeline(new Paging(page).sinceId(sinceId));
    }

    public List<Status> getFriendsTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends_timeline.json", null, paging, true));
    }

    public List<Status> getUserTimeline(String id, int count, String sinceId) throws WeiboException {
        return this.getUserTimeline(id, new Paging(sinceId).count(count));
    }

    public List<Status> getUserTimeline(String id, Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline/" + id + ".json", null, paging, this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline(String id, int count) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline/" + id + ".json", "count", String.valueOf(count), this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline(int count, String sinceId) throws WeiboException {
        return this.getUserTimeline(new Paging(sinceId).count(count));
    }

    public List<Status> getUserTimeline(String id) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline/" + id + ".json", this.http.isAuthenticationEnabled()));
    }

    public List<Status> getUserTimeline(String id, String sinceId) throws WeiboException {
        return this.getUserTimeline(id, new Paging(sinceId));
    }

    public List<Status> getUserTimeline() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", true));
    }

    public List<Status> getUserTimeline(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json", null, paging, true));
    }

    public List<Status> getUserTimelinePaging(String sinceId) throws WeiboException {
        return this.getUserTimeline(new Paging(sinceId));
    }

    public List<Status> getMentions() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/mentions.json", null, true));
    }

    public List<Status> getMentions(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/mentions.json", null, paging, true));
    }

    public List<Status> getRetweetedByMe() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_by_me.json", null, true));
    }

    public List<Status> getRetweetedByMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_by_me.json", null, true));
    }

    public List<Status> getRetweetedToMe() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_to_me.json", null, true));
    }

    public List<Status> getRetweetedToMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweeted_to_me.json", null, paging, true));
    }

    public List<Status> getRetweetsOfMe() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets_of_me.json", null, true));
    }

    public List<Status> getRetweetsOfMe(Paging paging) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets_of_me.json", null, paging, true));
    }

    public List<Status> getForwardsById(String mbId, int page, int count) throws WeiboException {
        PostParameter[] params = new PostParameter[]{new PostParameter("id", mbId), new PostParameter("page", page), new PostParameter("count", count)};
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/forwards/" + mbId + ".json", params, true));
    }

    public Status show(String id) throws WeiboException {
        return this.showStatus(id);
    }

    public Status showStatus(String id) throws WeiboException {
        return new Status(this.get(String.valueOf(this.getBaseURL()) + "statuses/show/" + id + ".json", true));
    }

    public Status update(String status) throws WeiboException {
        return this.updateStatus(status);
    }

    public Status updateStatus(String status) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status)}, true));
    }

    public Status updateStatusFile(String status, String fileids) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("fileids", fileids)}, true));
    }

    public Status updateStatusMentionEmail(String status, String mentionEmails) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("mentionEmails", mentionEmails)}, true));
    }

    public Comment updateComment(String comment, String id, String cid) throws WeiboException {
        PostParameter[] params = null;
        params = cid == null ? new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id)} : new PostParameter[]{new PostParameter("comment", comment), new PostParameter("cid", cid), new PostParameter("id", id)};
        return new Comment(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/comment.json", params, true));
    }

    public Status uploadStatus(String status, ImageItem item) throws WeiboException {
        try {
            String postUrl = String.valueOf(this.getBaseURL()) + "statuses/upload.json";
            if (this.getUserId() != null) {
                postUrl = String.valueOf(postUrl) + "?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8");
            }
            return new Status(this.http.multPartURL(postUrl, new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, item, true));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeiboException(e);
        }
    }

    public Status uploadStatus(String status, File file) throws WeiboException {
        try {
            String postUrl = String.valueOf(this.getBaseURL()) + "statuses/upload.json";
            if (this.getUserId() != null) {
                postUrl = String.valueOf(postUrl) + "?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8");
            }
            return new Status(this.http.multPartURL("pic", postUrl, new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source)}, file, true));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeiboException(e);
        }
    }

    public Status uploadStatus(String status, double latitude, double longitude, String location, File file) throws WeiboException {
        try {
            String postUrl = String.valueOf(this.getBaseURL()) + "statuses/upload.json";
            if (this.getUserId() != null) {
                postUrl = String.valueOf(postUrl) + "?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8");
            }
            return new Status(this.http.multPartURL("pic", postUrl, new PostParameter[]{new PostParameter("status", status), new PostParameter("source", this.source), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("address", location)}, file, true));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeiboException(e);
        }
    }

    public String uploadFile(File file) throws WeiboException {
        try {
            String postUrl = String.valueOf(this.getBaseURL()) + "multipart/upload.json";
            if (this.getUserId() != null) {
                postUrl = String.valueOf(postUrl) + "?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8");
            }
            Response resp = this.http.multPartURL("pic", postUrl, new PostParameter[]{new PostParameter("source", this.source)}, file, true);
            JSONObject json = resp.asJSONObject();
            return json.getString("result");
        }
        catch (Exception e) {
            throw new WeiboException(e);
        }
    }

    public Status updateStatus(String status, double latitude, double longitude) throws WeiboException, JSONException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", latitude), new PostParameter("long", longitude)}, true));
    }

    public Status update(String status, String inReplyToStatusId) throws WeiboException {
        return this.updateStatus(status, inReplyToStatusId);
    }

    public Status updateStatus(String status, String inReplyToStatusId) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true));
    }

    public Status updateStatus(String status, String inReplyToStatusId, double latitude, double longitude) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true));
    }

    public Status updateStatus(String status, String inReplyToStatusId, double latitude, double longitude, String location) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("address", location), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyToStatusId)), new PostParameter("source", this.source)}, true));
    }

    public Status destroyStatus(String statusId) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/destroy/" + statusId + ".json", new PostParameter[0], true));
    }

    public Comment destroyComment(String commentId) throws WeiboException {
        return new Comment(this.http.delete(String.valueOf(this.getBaseURL()) + "statuses/comment_destroy/" + commentId + ".json?source=" + this.CONSUMER_KEY, true));
    }

    public List<Comment> destroyComments(String ids) throws WeiboException {
        return Comment.constructComments(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/comment/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public List<Comment> destroyComments(String[] ids) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            sb.append(id).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return Comment.constructComments(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/comment/destroy_batch.json", new PostParameter[]{new PostParameter("ids", sb.toString())}, true));
    }

    public Status resetCount(int type) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/reset_count.json", new PostParameter[]{new PostParameter("type", type)}, true));
    }

    public Status retweetStatus(String statusId) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/retweet/" + statusId + ".json", new PostParameter[0], true));
    }

    public List<RetweetDetails> getRetweets(long statusId) throws WeiboException {
        return RetweetDetails.createRetweetDetails(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets/" + statusId + ".json", true));
    }

    public User getUserDetail(String id) throws WeiboException {
        return this.showUser(id);
    }

    public User showUser(String id) throws WeiboException {
        try {
            id = URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new User(this.get(String.valueOf(this.getBaseURL()) + "users/show/" + id + ".json", this.http.isAuthenticationEnabled()).asJSONObject());
    }

    public List<User> getFriends() throws WeiboException {
        return this.getFriendsStatuses();
    }

    public List<User> getFriendsStatuses() throws WeiboException {
        return User.constructResult(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", true));
    }

    public List<User> getFriends(Paging paging) throws WeiboException {
        return this.getFriendsStatuses(paging);
    }

    public List<User> getFriendsStatuses(Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json", null, paging, false));
    }

    public List<User> getFriendsStatuses(int cursor) throws WeiboException {
        return User.constructUser(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json?cursor=" + cursor, true));
    }

    public List<User> getFriends(int page) throws WeiboException {
        return this.getFriendsStatuses(page);
    }

    public List<User> getFriends(String id) throws WeiboException {
        return this.getFriendsStatuses(id);
    }

    public List<User> getFriendsStatuses(String id) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends/" + id + ".json", true));
    }

    public List<User> getFriends(String id, Paging paging) throws WeiboException {
        return this.getFriendsStatuses(id, paging);
    }

    public List<User> getFriendsStatuses(String id, Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends/" + id + ".json", false));
    }

    public List<User> getFriendsStatuses(String id, int cursor) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends/" + id + ".json?curosr=" + cursor, true));
    }

    public List<User> getFriendsStatuses(String id, int cursor, int count) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/friends/" + id + ".json?curosr=" + cursor + "&count=" + count, true));
    }

    public List<User> getFriends(String id, int page) throws WeiboException {
        return this.getFriendsStatuses(id, new Paging(page));
    }

    public List<User> getFollowers() throws WeiboException {
        return this.getFollowersStatuses();
    }

    public List<User> getFollowersStatuses() throws WeiboException {
        return User.constructResult(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", true));
    }

    public List<User> getFollowers(Paging paging) throws WeiboException {
        return this.getFollowersStatuses(paging);
    }

    public List<User> getFollowersStatuses(Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json", null, paging, false));
    }

    public List<User> getFollowersStatuses(int cursor) throws WeiboException {
        return User.constructUser(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json?cursor=" + cursor, true));
    }

    public List<User> getFollowers(int page) throws WeiboException {
        return this.getFollowersStatuses(new Paging(page));
    }

    public List<User> getFollowers(String id) throws WeiboException {
        return this.getFollowersStatuses(id);
    }

    public List<User> getFollowersStatuses(String id) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers/" + id + ".json", true));
    }

    public List<User> getFollowers(String id, Paging paging) throws WeiboException {
        return this.getFollowersStatuses(id, paging);
    }

    public List<User> getFollowersStatuses(String id, Paging paging) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers/" + id + ".json", null, paging, true));
    }

    public List<User> getFollowersStatuses(String id, int cursor) throws WeiboException {
        return User.constructUser(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers/" + id + ".json?cursor=" + cursor, true));
    }

    public List<User> getFollowersStatuses(String id, int cursor, int count) throws WeiboException {
        return User.constructUser(this.get(String.valueOf(this.getBaseURL()) + "statuses/followers/" + id + ".json?cursor=" + cursor + "&count=" + count, true));
    }

    public List<User> getFollowers(String id, int page) throws WeiboException {
        return this.getFollowersStatuses(id, new Paging(page));
    }

    public List<User> getFeatured() throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "statuses/featured.json", true));
    }

    public List<DirectMessage> getDirectMessages() throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(String.valueOf(this.getBaseURL()) + "direct_messages.json", true));
    }

    public List<DirectMessage> getDirectMessages(Paging paging) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(String.valueOf(this.getBaseURL()) + "direct_messages.json", null, paging, true));
    }

    public List<DirectMessage> getDirectMessagesByPage(int page) throws WeiboException {
        return this.getDirectMessages(new Paging(page));
    }

    public List<DirectMessage> getDirectMessages(int page, String sinceId) throws WeiboException {
        return this.getDirectMessages(new Paging(page).sinceId(sinceId));
    }

    public List<DirectMessage> getDirectMessages(String sinceId) throws WeiboException {
        return this.getDirectMessages(new Paging(sinceId));
    }

    public List<DirectMessage> getSentDirectMessages() throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(String.valueOf(this.getBaseURL()) + "direct_messages/sent.json", new PostParameter[0], true));
    }

    public List<DirectMessage> getSentDirectMessages(Paging paging) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.get(String.valueOf(this.getBaseURL()) + "direct_messages/sent.json", new PostParameter[0], paging, true));
    }

    public List<DirectMessage> getSentDirectMessages(String sinceId) throws WeiboException {
        return this.getSentDirectMessages(new Paging(sinceId));
    }

    public List<DirectMessage> getSentDirectMessages(int page, String sinceId) throws WeiboException {
        return this.getSentDirectMessages(new Paging(page, sinceId));
    }

    public DirectMessage sendDirectMessage(String id, String text) throws WeiboException {
        return this.sendDirectMessage(id, text, false);
    }

    public DirectMessage sendDirectMessage(String id, String text, String fileids) throws WeiboException {
        return this.sendDirectMessage(id, text, fileids, false);
    }

    public DirectMessage sendDirectMessage(String id, String text, boolean sendMail) throws WeiboException {
        return new DirectMessage(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/new.json", new PostParameter[]{new PostParameter("user_id", id), new PostParameter("text", text), new PostParameter("send_email", Boolean.toString(sendMail)), new PostParameter("source", this.source)}, true).asJSONObject());
    }

    public DirectMessage sendDirectMessage(String id, String text, String fileids, boolean sendMail) throws WeiboException {
        return new DirectMessage(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/new.json", new PostParameter[]{new PostParameter("user_id", id), new PostParameter("text", text), new PostParameter("fileids", fileids), new PostParameter("send_email", Boolean.toString(sendMail)), new PostParameter("source", this.source)}, true).asJSONObject());
    }

    public DirectMessage sendDirectMessage(String id, String text, double latitude, double longitude, String location) throws WeiboException {
        return new DirectMessage(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/new.json", new PostParameter[]{new PostParameter("user_id", id), new PostParameter("text", text), new PostParameter("source", this.source), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("address", location)}, true).asJSONObject());
    }

    public DirectMessage deleteDirectMessage(String id) throws WeiboException {
        return this.destroyDirectMessage(id);
    }

    public DirectMessage destroyDirectMessage(String id) throws WeiboException {
        return new DirectMessage(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/destroy/" + id + ".json", new PostParameter[0], true).asJSONObject());
    }

    public List<DirectMessage> destroyDirectMessages(String ids) throws WeiboException {
        return DirectMessage.constructDirectMessages(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public List<DirectMessage> destroyDirectMessages(String[] ids) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            sb.append(id).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return DirectMessage.constructDirectMessages(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/destroy_batch.json", new PostParameter[]{new PostParameter("ids", sb.toString())}, true));
    }

    public User createFriendship(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create/" + id + ".json", new PostParameter[0], true).asJSONObject());
    }

    public User createFriendship(String id, boolean follow) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create/" + id + ".json", new PostParameter[]{new PostParameter("follow", String.valueOf(follow))}, true).asJSONObject());
    }

    public User destroyFriendship(String id) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/destroy/" + id + ".json", new PostParameter[0], true).asJSONObject());
    }

    public boolean existsFriendship(String userA, String userB) throws WeiboException {
        return -1 != this.get(String.valueOf(this.getBaseURL()) + "friendships/exists.json", "user_a", userA, "user_b", userB, true).asString().indexOf("true");
    }

    public IDs getFriendsIDs() throws WeiboException {
        return this.getFriendsIDs(-1L);
    }

    public IDs getFriendsIDs(Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json", null, paging, true), this);
    }

    public IDs getFriendsIDs(long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json?cursor=" + cursor, true), this);
    }

    public IDs getFriendsIDs(String userId) throws WeiboException {
        return this.getFriendsIDs(userId, -1L);
    }

    public IDs getFriendsIDs(String userId, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json?user_id=" + userId, null, paging, true), this);
    }

    public IDs getFriendsIDs(String userId, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor, true), this);
    }

    public IDs getFriendsIDsByName(String screenName) throws WeiboException {
        return this.getFriendsIDsByName(screenName, -1L);
    }

    public IDs getFriendsIDsByName(String screenName, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "friends/ids.json?screen_name=" + screenName + "&cursor=" + cursor, true), this);
    }

    public IDs getFollowersIDs() throws WeiboException {
        return this.getFollowersIDs(-1L);
    }

    public IDs getFollowersIDs(Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json", null, paging, true), this);
    }

    public IDs getFollowersIDs(long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?cursor=" + cursor, true), this);
    }

    public IDs getFollowersIDs(String userId) throws WeiboException {
        return this.getFollowersIDs(userId, -1L);
    }

    public IDs getFollowersIDs(String userId, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?user_id=" + userId, null, paging, true), this);
    }

    public IDs getFollowersIDs(String userId, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?user_id=" + userId + "&cursor=" + cursor, true), this);
    }

    public IDs getFollowersIDsByName(String screenName) throws WeiboException {
        return this.getFollowersIDsByName(screenName, -1L);
    }

    public IDs getFollowersIDsByName(String screenName, Paging paging) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?screen_name=" + screenName, null, paging, true), this);
    }

    public IDs getFollowersIDsByName(String screenName, long cursor) throws WeiboException {
        return new IDs(this.get(String.valueOf(this.getBaseURL()) + "followers/ids.json?screen_name=" + screenName + "&cursor=" + cursor, true), this);
    }

    public User verifyCredentials() throws WeiboException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "account/verify_credentials.json", true).asJSONObject());
    }

    public User updateProfile(String name, String department, String jobTitle) throws WeiboException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "account/update_profile.json", new PostParameter[]{new PostParameter("name", name)}, true).asJSONObject());
    }

    public User updateProfileImage(File image) throws WeiboException {
        return new User(this.http.multPartURL("image", String.valueOf(this.getBaseURL()) + "account/update_profile_image.json", new PostParameter[]{new PostParameter("source", this.source)}, image, true).asJSONObject());
    }

    public List<Status> favorites() throws WeiboException {
        return this.getFavorites();
    }

    public List<Status> getFavorites() throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites.json", new PostParameter[0], true));
    }

    public List<Status> favorites(int page) throws WeiboException {
        return this.getFavorites(page);
    }

    public List<Status> getFavorites(int page) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites.json", "page", String.valueOf(page), true));
    }

    public List<Status> favorites(String id) throws WeiboException {
        return this.getFavorites(id);
    }

    public List<Status> getFavorites(String id) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites/" + id + ".json", new PostParameter[0], true));
    }

    public List<Status> favorites(String id, int page) throws WeiboException {
        return this.getFavorites(id, page);
    }

    public List<Status> getFavorites(String id, int page) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites/" + id + ".json", "page", String.valueOf(page), true));
    }

    public Status createFavorite(long id) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/create/" + id + ".json", true));
    }

    public Status destroyFavorite(long id) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy/" + id + ".json", true));
    }

    public List<Status> destroyFavorites(String ids) throws WeiboException {
        return Status.constructStatuses(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public List<Status> destroyFavorites(String[] ids) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            sb.append(id).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return Status.constructStatuses(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", sb.toString())}, true));
    }

    public boolean isJoinNetwork(String subDomainName, String userId) throws WeiboException, JSONException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseURL()).append("network/is_join/").append(subDomainName).append("/").append(userId).append(".json").append("?source=").append(this.CONSUMER_KEY);
        String url = sb.toString();
        String httpMethod = "GET";
        JSONObject json = this.http.httpRequest(url, null, true, httpMethod).asJSONObject();
        return (Boolean)json.get("is_join");
    }

    public boolean test() throws WeiboException {
        return -1 != this.get(String.valueOf(this.getBaseURL()) + "help/test.json", false).asString().indexOf("ok");
    }

    public String getDowntimeSchedule() throws WeiboException {
        throw new WeiboException("this method is not supported by the Weibo API anymore", new NoSuchMethodException("this method is not supported by the Weibo API anymore"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Weibo weibo = (Weibo)o;
        if (!this.baseURL.equals(weibo.baseURL)) {
            return false;
        }
        if (!this.format.equals(weibo.format)) {
            return false;
        }
        if (!this.http.equals(weibo.http)) {
            return false;
        }
        if (!this.searchBaseURL.equals(weibo.searchBaseURL)) {
            return false;
        }
        return this.source.equals(weibo.source);
    }

    public int hashCode() {
        int result = this.http.hashCode();
        result = 31 * result + this.baseURL.hashCode();
        result = 31 * result + this.searchBaseURL.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.format.hashCode();
        return result;
    }

    public String toString() {
        return "Weibo{http=" + this.http + ", baseURL='" + this.baseURL + '\'' + ", searchBaseURL='" + this.searchBaseURL + '\'' + ", source='" + this.source + '\'' + ", format=" + this.format + '}';
    }

    public List<Comment> getComments(String id) throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments.json?id=" + id, true));
    }

    public List<Comment> getCommentsTimeline() throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_timeline.json", true));
    }

    public List<Comment> getCommentsByMe() throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_by_me.json", true));
    }

    public List<Comment> getCommentsToMe() throws WeiboException {
        return Comment.constructComments(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_to_me.json", true));
    }

    public List<Count> getCounts(String ids) throws WeiboException {
        return Count.constructCounts(this.get(String.valueOf(this.getBaseURL()) + "statuses/counts.json?ids=" + ids, true));
    }

    public Count getUnread() throws WeiboException, JSONException {
        return new Count(this.get(String.valueOf(this.getBaseURL()) + "statuses/unread.json", true).asJSONObject());
    }

    public Status repost(String sid, String status) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/repost.json", new PostParameter[]{new PostParameter("id", sid), new PostParameter("status", status)}, true));
    }

    public List<Status> getrepostbyme(String id) throws WeiboException {
        return Status.constructStatuses(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/repost_by_me.json" + "?source=" + this.CONSUMER_KEY + "&id=" + id, true));
    }

    public List<Status> getreposttimeline(String id) throws WeiboException {
        return Status.constructStatuses(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/repost_timeline.json" + "?source=" + this.CONSUMER_KEY + "&id=" + id, true));
    }

    public List<Status> gethotcmt(int page, int count, int countLimit, int commentCount, boolean ascending, String type) throws WeiboException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getBaseURL()) + "statuses/hotcmt.json").append("?source=" + this.CONSUMER_KEY).append("&page=").append(page).append("&count=").append(count).append("&countLimit=").append(countLimit).append("&ascending=").append(ascending).append("&commentCount=").append(commentCount).append("&type=").append(type).append("&status=").append("%F0%9F%87%AF%F0%9F%87%B5%F0%9F%87%B0%F0%9F%87%B7%F0%9F%87%A8%F0%9F%87%B3%F0%9F%87%BA%F0%9F%87%B8");
        String url = sb.toString();
        Response res = this.http.get(url, true);
        return Status.constructStatuses(res);
    }

    public Status reply(String sid, String cid, String comment) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/reply.json", new PostParameter[]{new PostParameter("id", sid), new PostParameter("cid", cid), new PostParameter("comment", comment)}, true));
    }

    public JSONObject showFriendships(String target_id) throws WeiboException {
        return this.get(String.valueOf(this.getBaseURL()) + "friendships/show.json?target_id=" + target_id, true).asJSONObject();
    }

    public JSONObject showFriendships(String source_id, String target_id) throws WeiboException {
        return this.get(String.valueOf(this.getBaseURL()) + "friendships/show.json?target_id=" + target_id + "&source_id=" + source_id + "&source=" + this.CONSUMER_KEY, true).asJSONObject();
    }

    public User endSession() throws WeiboException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "account/end_session.json", true).asJSONObject());
    }

    public JSONObject register(String ip, String ... args) throws WeiboException {
        return this.http.post(String.valueOf(this.getBaseURL()) + "account/register.json", new PostParameter[]{new PostParameter("nick", args[2]), new PostParameter("gender", args[3]), new PostParameter("password", args[4]), new PostParameter("email", args[5]), new PostParameter("ip", ip)}, true).asJSONObject();
    }

    public List<Tag> gettags(String user_id) throws WeiboException {
        return Tag.constructTags(this.http.get(String.valueOf(this.getBaseURL()) + "tags.json?" + "user_id=" + user_id, true));
    }

    public List<Tag> createTags(String tags) throws WeiboException, JSONException {
        return Tag.constructTags(this.http.post(String.valueOf(this.getBaseURL()) + "tags/create.json", new PostParameter[]{new PostParameter("tags", tags)}, true));
    }

    public List<Tag> getSuggestions() throws WeiboException {
        return Tag.constructTags(this.get(String.valueOf(this.getBaseURL()) + "tags/suggestions.json", true));
    }

    public JSONObject destoryTag(String tag_id) throws WeiboException {
        return this.http.post(String.valueOf(this.getBaseURL()) + "tags/destroy.json", new PostParameter[]{new PostParameter("tag_id", tag_id)}, true).asJSONObject();
    }

    public List<Tag> destory_batchTags(String ids) throws WeiboException {
        return Tag.constructTags(this.http.post(String.valueOf(this.getBaseURL()) + "tags/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, true));
    }

    public UserWapper members(long cursor) throws WeiboException {
        return User.constructWapperUsers(this.get(String.valueOf(this.getBaseURL()) + "users/members.json", "cursor", String.valueOf(cursor), true));
    }

    public Comment uploadComment(String comment, String id, String cid, ImageItem item) throws WeiboException {
        PostParameter[] params = null;
        params = cid == null ? new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id)} : new PostParameter[]{new PostParameter("comment", comment), new PostParameter("cid", cid), new PostParameter("id", id)};
        try {
            return new Comment(this.http.multPartURL(String.valueOf(this.getBaseURL()) + "statuses/upload_comment.json?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8"), params, item, true));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeiboException(e);
        }
    }

    public DirectMessage uploadDirectMessage(String participants, String text, File file) throws WeiboException {
        return new DirectMessage(this.http.multPartURL("pic", String.valueOf(this.getBaseURL()) + "direct_messages/upload.json", new PostParameter[]{new PostParameter("participants", participants), new PostParameter("text", text)}, file, true).asJSONObject());
    }

    public DirectMessage uploadDirectMessage(String participants, String text, double latitude, double longitude, String location, File file) throws WeiboException {
        return new DirectMessage(this.http.multPartURL("pic", String.valueOf(this.getBaseURL()) + "direct_messages/upload.json", new PostParameter[]{new PostParameter("participants", participants), new PostParameter("text", text), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("address", location)}, file, true).asJSONObject());
    }

    public List<Group> getJoinedGroups(String userId, int page, int count) throws WeiboException {
        if (userId == null) {
            return Group.constructList(this.get(String.valueOf(this.getBaseURL()) + "group/joined.json", new PostParameter[]{new PostParameter("page", page), new PostParameter("count", count)}, true));
        }
        return Group.constructList(this.get(String.valueOf(this.getBaseURL()) + "group/joined.json", new PostParameter[]{new PostParameter("user_id", userId), new PostParameter("page", page), new PostParameter("count", count)}, true));
    }

    public List<Status> getGroupTimeline(Paging paging, String groupId) throws WeiboException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "group/statuses/timeline.json", new PostParameter[]{new PostParameter("group_id", groupId)}, paging, true));
    }

    public Status uploadGroupStatus(String groupId, String status, ImageItem item) throws WeiboException {
        try {
            String url = String.valueOf(this.getBaseURL()) + "group/statuses/upload.json";
            if (this.getUserId() != null) {
                url = "?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8");
            }
            return new Status(this.http.multPartURL(url, new PostParameter[]{new PostParameter("group_id", groupId), new PostParameter("status", status), new PostParameter("source", this.source)}, item, true));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeiboException(e);
        }
    }

    public Status updateGroupStatus(String groupId, String status) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "group/statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("group_id", groupId)}, true));
    }

    public Status updateGroupStatus(String groupId, String status, double latitude, double longitude, String location) throws WeiboException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "group/statuses/update.json", new PostParameter[]{new PostParameter("status", status), new PostParameter("group_id", groupId), new PostParameter("lat", latitude), new PostParameter("long", longitude), new PostParameter("address", location)}, true));
    }

    public Comment commentGroup(String groupId, String sid, String cid, String comment) throws WeiboException {
        PostParameter[] params = null;
        params = cid == null ? new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", sid)} : new PostParameter[]{new PostParameter("comment", comment), new PostParameter("cid", cid), new PostParameter("id", sid)};
        return new Comment(this.http.post(String.valueOf(this.getBaseURL()) + "group/statuses/comment.json", params, true));
    }

    public Comment uploadCommentGroup(String groupId, String sid, String cid, String comment, boolean comment_ori, boolean forward, ImageItem item) throws WeiboException {
        try {
            PostParameter[] params = null;
            params = cid == null ? new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", sid), new PostParameter("comment_ori", comment_ori ? 1 : 0), new PostParameter("forward", forward ? 1 : 0)} : new PostParameter[]{new PostParameter("comment", comment), new PostParameter("cid", cid), new PostParameter("id", sid), new PostParameter("comment_ori", comment_ori ? 1 : 0), new PostParameter("forward", forward ? 1 : 0)};
            return new Comment(this.http.multPartURL(String.valueOf(this.getBaseURL()) + "group/statuses/upload_comment.json?xoauth_requestor_id=" + URLEncoder.encode(this.getUserId(), "UTF-8"), params, item, true));
        }
        catch (UnsupportedEncodingException e) {
            throw new WeiboException(e);
        }
    }

    public List<String> addGroupMember(String groupId, String userIds) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "group/add_member.json", new PostParameter[]{new PostParameter("user_ids", userIds), new PostParameter("group_id", groupId)}, true);
        JSONArray jsonArray = res.asJSONArray();
        ArrayList<String> rt = new ArrayList<String>();
        try {
            if (jsonArray.length() > 0) {
                int i = 0;
                int n = jsonArray.length();
                while (i < n) {
                    rt.add(jsonArray.getString(i));
                    ++i;
                }
            }
            return rt;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + jsonArray.toString(), je);
        }
    }

    public boolean userExists(String email) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "admin/exists.json?source=" + this.CONSUMER_KEY, "email", email, false);
        JSONObject json = res.asJSONObject();
        try {
            return "true".equals(json.getString("exists"));
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String getUserId(String email) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "admin/exists.json?source=" + this.CONSUMER_KEY, "email", email, false);
        JSONObject json = res.asJSONObject();
        try {
            if ("true".equals(json.getString("exists"))) {
                return json.getString("id");
            }
            return null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public User createUser(String email, String name, String department, String jobTitle) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/create_user.json", new PostParameter[]{new PostParameter("email", email), new PostParameter("name", name), new PostParameter("department", department), new PostParameter("job_title", jobTitle)}, true);
        return new User(res.asJSONObject());
    }

    public UserAndToken createUserAndToken(String email, String name, String department, String jobTitle) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/create_user.json", new PostParameter[]{new PostParameter("email", email), new PostParameter("name", name), new PostParameter("department", department), new PostParameter("job_title", jobTitle), new PostParameter("generate_access_token", "true")}, true);
        return new UserAndToken(res);
    }

    public UserAndToken createCommunityUserAndToken(String communityUuid, String email, String name, String department, String jobTitle, String password) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + communityUuid + "/admin/create_community_user.json", new PostParameter[]{new PostParameter("email", email), new PostParameter("name", name), new PostParameter("department", department), new PostParameter("job_title", jobTitle), new PostParameter("password", password), new PostParameter("generate_access_token", "true")}, true);
        return new UserAndToken(res);
    }

    public UserTokenList batchGetAccessToken(String emails) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/gen_access_token.json", new PostParameter[]{new PostParameter("email", emails)}, true);
        return new UserTokenList(res);
    }

    public UserTokenList batchGetCommunityAccessToken(String emails) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/gen_community_access_token.json", new PostParameter[]{new PostParameter("email", emails)}, true);
        return new UserTokenList(res);
    }

    public boolean inviteCommunity(String email) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/community_invite.json", new PostParameter[]{new PostParameter("email", email)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getBoolean("success");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean deleteUser(String email) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/delete_user.json", new PostParameter[]{new PostParameter("email", email)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return "true".equals(json.getString("success"));
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public User createUnVerifiedUser(String email, String name, String department, String jobTitle) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/create_unverified_user.json", new PostParameter[]{new PostParameter("email", email), new PostParameter("name", name), new PostParameter("department", department), new PostParameter("job_title", jobTitle)}, true);
        return new User(res.asJSONObject());
    }

    public boolean userResister(String email) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/register.json", new PostParameter[]{new PostParameter("email", email)}, false);
        JSONObject json = res.asJSONObject();
        try {
            return "true".equals(json.getString("success"));
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String getWebLoginToken() throws WeiboException {
        Response res = this.http.get(String.valueOf(this.getBaseURL()) + "oauth/weblogin_token", true);
        JSONObject json = res.asJSONObject();
        try {
            if ("true".equals(json.getString("success"))) {
                String token = json.getString("lgtk");
                return token;
            }
            throw new WeiboException("error:" + json.toString());
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String getWebLoginToken(String userName, String domain) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "oauth/weblogin_token", new PostParameter[]{new PostParameter("type", "WEBLOGIN"), new PostParameter("user", userName), new PostParameter("domain", domain)}, true);
        JSONObject json = res.asJSONObject();
        try {
            if ("true".equals(json.getString("success"))) {
                String token = json.getString("lgtk");
                return token;
            }
            throw new WeiboException("error:" + json.toString());
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String getUnVerifiledLoginToken(String email, String domain) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "oauth/weblogin_token", new PostParameter[]{new PostParameter("type", "UNVERIFIED"), new PostParameter("user", email), new PostParameter("domain", domain)}, true);
        JSONObject json = res.asJSONObject();
        try {
            if ("true".equals(json.getString("success"))) {
                String token = json.getString("lgtk");
                return token;
            }
            throw new WeiboException("error:" + json.toString());
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String getAppToken(String domain) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "oauth/weblogin_token", new PostParameter[]{new PostParameter("type", "APP"), new PostParameter("domain", domain)}, true);
        JSONObject json = res.asJSONObject();
        try {
            if ("true".equals(json.getString("success"))) {
                String token = json.getString("lgtk");
                return token;
            }
            throw new WeiboException("error:" + json.toString());
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Map<String, Integer> getStreamUnread(String targetIds, String type) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/unread.json?targetIds=" + targetIds + "&type=" + type, true);
        JSONObject json = res.asJSONObject();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                map.put(key, json.getInt(key));
            }
            return map;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public long streamCommentUnread() throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/unread_byuser.json", true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getLong("unreadCommentCount");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public long streamMentionUnread() throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/unread_byuser.json", true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getLong("unreadMentionCount");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Map<String, Long> userAllUnread(boolean onlyInteractive) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/unread_byuser.json?onlyInteractive=" + onlyInteractive, true);
        JSONObject json = res.asJSONObject();
        HashMap<String, Long> result = new HashMap<String, Long>();
        try {
            result.put("unreadMentionCount", json.getLong("unreadMentionCount"));
            result.put("unreadCommentCount", json.getLong("unreadCommentCount"));
            result.put("unreadSubscribeCount", json.getLong("unreadActivityCount"));
            result.put("unreadParticipateCount", json.getLong("unreadActivityCountParticipate"));
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
        return result;
    }

    public Map<String, Long> userAllUnread() throws WeiboException {
        return this.userAllUnread(false);
    }

    public Map<String, Long> userFeedUnread() throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/unread_feed.json", true);
        JSONObject json = res.asJSONObject();
        HashMap<String, Long> result = new HashMap<String, Long>();
        try {
            result.put("participate", json.getLong("participate"));
            result.put("subscribe", json.getLong("subscribe"));
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
        return result;
    }

    public boolean streamFeedExist(String targetId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/exist.json?targetId=" + targetId, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getBoolean("exist");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean createStreamFeed(String targetId, String subscriberEmails, String category, String title, String creator, String number, String digest, String state, boolean subscribe, boolean participate) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/create.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("subscribers", subscriberEmails), new PostParameter("category", category), new PostParameter("title", title), new PostParameter("creator", creator), new PostParameter("number", number), new PostParameter("digest", digest), new PostParameter("participate", participate ? "true" : "false"), new PostParameter("subscribe", subscribe ? "true" : "false"), new PostParameter("state", state)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("id") != null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean modifyFeedTitle(String networkId, String targetId, String title) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/update_title.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("networkId", networkId), new PostParameter("title", title)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("isSuccess") == "true";
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean updateStreamFeedMetas(String targetId, String category, String creator, String number, String digest, String state, String conversationState) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/update.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("category", category), new PostParameter("creator", creator), new PostParameter("number", number), new PostParameter("digest", digest), new PostParameter("state", state), new PostParameter("conversationState", conversationState)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("id") != null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean subscribeStreamFeed(String targetId, String subscriberEmails) throws WeiboException {
        return this.subscribeStreamFeed(targetId, subscriberEmails, true);
    }

    public boolean subscribeStreamFeed(String targetId, String subscriberEmails, boolean sendLog) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/subscribe.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("subscribers", subscriberEmails), new PostParameter("sendLog", sendLog ? "true" : "false")}, true);
        JSONArray jsonArray = res.asJSONArray();
        return jsonArray.length() > 0;
    }

    public boolean subscribeStreamFeedById(String targetId, String subscriberIds, boolean sendLog) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/subscribe_by_id.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("subscriberIds", subscriberIds), new PostParameter("sendLog", sendLog ? "true" : "false")}, true);
        JSONArray jsonArray = res.asJSONArray();
        return jsonArray.length() > 0;
    }

    public List<Feed> streamFeeds(String userId, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feeds.json", new PostParameter[]{new PostParameter("userId", userId), new PostParameter("page", page), new PostParameter("count", count)}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedSubscribeTimeline(String categoryName, int activityCount, int page, int count) throws WeiboException {
        return this.feedSubscribeTimeline(categoryName, false, activityCount, page, count);
    }

    public List<Feed> feedSubscribeTimeline(String categoryName, boolean onlyInteractive, int activityCount, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_subscribe_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyInteractive", onlyInteractive ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedSubscribeTimelineOnlyUnread(String categoryName, int activityCount, int page, int count, boolean onlyUnread) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_subscribe_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyUnread", onlyUnread ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedDynamicTimeline(String categoryName, int activityCount, int page, int count) throws WeiboException {
        return this.feedDynamicTimeline(categoryName, false, activityCount, page, count);
    }

    public List<Feed> feedDynamicTimeline(String categoryName, boolean onlyInteractive, int activityCount, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_dynamic_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyInteractive", onlyInteractive ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedSubscribeTimelineOnlyUnread(String categoryName, int activityCount, Date from, Date to, int page, int count, boolean onlyUnread) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_subscribe_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("from", from != null ? from.getTime() : 0L), new PostParameter("to", to != null ? to.getTime() : 0L), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyUnread", onlyUnread ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedDynamicTimelineOnlyUnread(String categoryName, int activityCount, Date from, Date to, int page, int count, boolean onlyUnread) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_dynamic_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("from", from != null ? String.valueOf(from.getTime()) : ""), new PostParameter("to", to != null ? to.getTime() : 0L), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyUnread", onlyUnread ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedDynamicTimelineOnlyUnread(String categoryName, int activityCount, Date from, Date to, boolean onlyInteractive, int page, int count, boolean onlyUnread) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_dynamic_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("from", from != null ? String.valueOf(from.getTime()) : ""), new PostParameter("to", to != null ? to.getTime() : 0L), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyUnread", onlyUnread ? "true" : "false"), new PostParameter("onlyInteractive", onlyInteractive ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedDynamicTimelineOnlyUnread(String categoryName, int activityCount, int page, int count, boolean onlyUnread) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_dynamic_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyUnread", onlyUnread ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedDynamicTimelineOnlyUnread(String categoryName, int activityCount, boolean onlyInteractive, int page, int count, boolean onlyUnread) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_dynamic_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("page", page), new PostParameter("count", count), new PostParameter("onlyUnread", onlyUnread ? "true" : "false"), new PostParameter("onlyInteractive", onlyInteractive ? "true" : "false")}, true);
        return Feed.constructList(res);
    }

    public List<Feed> feedCompletedTimeline(String categoryName, int activityCount, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_completed_timeline.json", new PostParameter[]{new PostParameter("categoryName", categoryName != null ? categoryName : ""), new PostParameter("activityCount", activityCount), new PostParameter("page", page), new PostParameter("count", count)}, true);
        return Feed.constructList(res);
    }

    public List<Feed> hotStreamFeedsRecently(int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/hot_feed.json", new PostParameter[]{new PostParameter("count", count)}, true);
        return Feed.constructList(res);
    }

    public List<User> getFeedParticipants(String userId, String targetId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_participants.json", new PostParameter[]{new PostParameter("userId", userId), new PostParameter("targetId", targetId)}, true);
        ArrayList<User> users = new ArrayList<User>();
        JSONArray jsonArr = res.asJSONArray();
        if (jsonArr != null) {
            int length = jsonArr.length();
            JSONObject obj = null;
            int i = 0;
            while (i < length) {
                try {
                    obj = jsonArr.getJSONObject(i);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (obj != null) {
                    users.add(new User(obj));
                }
                ++i;
            }
        }
        return users;
    }

    public List<User> getFeedSubscribers(String userId, String targetId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_subscribers.json", new PostParameter[]{new PostParameter("userId", userId), new PostParameter("targetId", targetId)}, true);
        ArrayList<User> users = new ArrayList<User>();
        JSONArray jsonArr = res.asJSONArray();
        if (jsonArr != null) {
            int length = jsonArr.length();
            JSONObject obj = null;
            int i = 0;
            while (i < length) {
                try {
                    obj = jsonArr.getJSONObject(i);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (obj != null) {
                    users.add(new User(obj));
                }
                ++i;
            }
        }
        return users;
    }

    public boolean addFeedParticipant(String userId, String targetId, String participantIds) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/add_feed_participants.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("userId", userId), new PostParameter("participantIds", participantIds)}, true);
        JSONArray jsonArray = res.asJSONArray();
        return jsonArray.length() > 0;
    }

    public List<Attachment> feedRelatedDoc(String userId, String targetId, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_dynamic_timeline.json", new PostParameter[]{new PostParameter("userId", userId), new PostParameter("targetId", targetId), new PostParameter("page", page), new PostParameter("count", count)}, true);
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        JSONArray jsonArray = res.asJSONArray();
        if (jsonArray != null && jsonArray.length() > 0) {
            int i = 0;
            while (i < jsonArray.length()) {
                JSONObject obj = null;
                try {
                    obj = jsonArray.getJSONObject(i);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (obj != null) {
                    JSONObject atm = null;
                    try {
                        atm = obj.getJSONObject("attachment");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    try {
                        Attachment attachment = new Attachment(atm);
                        result.add(attachment);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public Feed streamFeedDetail(String targetId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/feed_detail.json", new PostParameter[]{new PostParameter("targetId", targetId)}, true);
        return new Feed(res);
    }

    public List<Activity> streamTargetTimeline(String targetId, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/target_timeline.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("page", page), new PostParameter("count", count)}, true);
        return Activity.constructList(res);
    }

    public List<Activity> streamUserTimeline(String userId, int page, int count) throws WeiboException {
        HashSet<PostParameter> parameters = new HashSet<PostParameter>();
        parameters.add(new PostParameter("page", page));
        parameters.add(new PostParameter("count", count));
        if (userId != null) {
            parameters.add(new PostParameter("userId", userId));
        }
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/user_timeline.json", parameters.toArray(new PostParameter[0]), true);
        return Activity.constructList(res);
    }

    public List<Activity> streamMentionsTimeline(String userId, int page, int count) throws WeiboException {
        HashSet<PostParameter> parameters = new HashSet<PostParameter>();
        parameters.add(new PostParameter("page", page));
        parameters.add(new PostParameter("count", count));
        if (userId != null) {
            parameters.add(new PostParameter("userId", userId));
        }
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/mentions_timeline.json", parameters.toArray(new PostParameter[0]), true);
        return Activity.constructList(res);
    }

    public List<Activity> streamReplyToMeTimeline(String userId, int page, int count) throws WeiboException {
        HashSet<PostParameter> parameters = new HashSet<PostParameter>();
        parameters.add(new PostParameter("page", page));
        parameters.add(new PostParameter("count", count));
        if (userId != null) {
            parameters.add(new PostParameter("userId", userId));
        }
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/reply_to_user.json", parameters.toArray(new PostParameter[0]), true);
        return Activity.constructList(res);
    }

    public List<Activity> streamMySendTimeline(String userId, int page, int count) throws WeiboException {
        HashSet<PostParameter> parameters = new HashSet<PostParameter>();
        parameters.add(new PostParameter("page", page));
        parameters.add(new PostParameter("count", count));
        if (userId != null) {
            parameters.add(new PostParameter("userId", userId));
        }
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/user_send.json", parameters.toArray(new PostParameter[0]), true);
        return Activity.constructList(res);
    }

    public Activity streamActivityDetail(String activityId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/activity_detail.json", new PostParameter[]{new PostParameter("activityId", activityId)}, true);
        return new Activity(res);
    }

    public List<ActivityComment> streamCommentsTimeline(String activityId, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/comments_timeline.json", new PostParameter[]{new PostParameter("activityId", activityId), new PostParameter("page", page), new PostParameter("count", count)}, true);
        try {
            JSONArray commentsJsonList = res.asJSONArray();
            return ActivityComment.constructList(commentsJsonList);
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + res.toString(), je);
        }
    }

    public boolean postStreamMessage(String targetId, String actor, String verb, String content) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/post_activity.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("actor", actor), new PostParameter("verb", verb), new PostParameter("type", "LOG"), new PostParameter("targetType", "EAS_BILL"), new PostParameter("content", content)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("id") != null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean postTextStreamMessage(String targetId, String content) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/post_text_activity.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("content", content)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("id") != null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean uploadTextStreamMessage(String targetId, String content, File file) throws WeiboException {
        Response res = this.http.multPartURL("pic", String.valueOf(this.getBaseURL()) + "stream/upload_activity.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("content", content)}, file, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("id") != null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean postCommentToActivity(String activityId, String replyCommentId, String content) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/comment.json", new PostParameter[]{new PostParameter("activityId", activityId), new PostParameter("replyCommentId", replyCommentId), new PostParameter("content", content)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getString("id") != null;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean deleteActivity(String activityId) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/destory_activity.json", new PostParameter[]{new PostParameter("activityId", activityId)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return "true".equals(json.getString("success"));
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean checkSubscribe(String targetId, String subscriber) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "stream/check_subscribe.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("subscriber", subscriber)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getBoolean("isSubscribe");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public boolean unSubscribe(String targetId, String subscriberEmails) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "stream/unsubscribe.json", new PostParameter[]{new PostParameter("targetId", targetId), new PostParameter("subscribers", subscriberEmails)}, true);
        JSONObject json = res.asJSONObject();
        try {
            return json.getBoolean("success");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Status uploadCrash(String uploader_email, File crash) throws WeiboException {
        return new Status(this.http.multPartURL("crash", String.valueOf(this.getBaseURL()) + "client/upload_crash_report.json", new PostParameter[]{new PostParameter("uploader_email", uploader_email), new PostParameter("source", this.source)}, crash, true));
    }

    public List<User> searchUsers(String q) throws WeiboException {
        return User.constructUsers(this.get(String.valueOf(this.getBaseURL()) + "users/search.json", new PostParameter[]{new PostParameter("q", q)}, true));
    }

    public String storeDevice(String AppVersion, int buildNo, String device_token, boolean product) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "client/store_device.json", new PostParameter[]{new PostParameter("app_version", AppVersion), new PostParameter("app_buildno", buildNo), new PostParameter("device_token", device_token), new PostParameter("product", String.valueOf(product)), new PostParameter("device_token", device_token)}, true);
        JSONObject json = res.asJSONObject();
        try {
            String id = json.getString("id");
            return id;
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public Status shareClientUpdate(String AppVersion) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "client/share_client_update.json", new PostParameter[]{new PostParameter("version", AppVersion)}, true);
        return new Status(res);
    }

    public Response downlodaFile(String fileId) throws WeiboException {
        String url = String.valueOf(this.getBaseURL()) + "download/" + fileId + "?source=" + this.CONSUMER_KEY;
        Response res = this.http.get(url, true);
        return res;
    }

    public Response addUserToCommunity(String userId, String subDomainName) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "network/appauth/join/" + userId + ".json", new PostParameter[]{new PostParameter("subDomainName", subDomainName)}, true);
        return res;
    }

    public JSONArray getUserAuthApps(String userId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "client/user_applications.json", new PostParameter[]{new PostParameter("user_id", userId)}, true);
        JSONArray arr = res.asJSONArray();
        return arr;
    }

    public Response fireInvokeURL(String target_key, String target_type, String target_version, String my_version) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "client/fire_invoke_url.json", new PostParameter[]{new PostParameter("target_key", target_key), new PostParameter("target_type", target_type), new PostParameter("target_version", target_version), new PostParameter("my_version", my_version)}, true);
        return res;
    }

    public JSONArray userCommunities(String userEmail, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "community/list/user_communities.json", new PostParameter[]{new PostParameter("user_email", userEmail), new PostParameter("page", page), new PostParameter("count", count)}, true);
        JSONArray arr = res.asJSONArray();
        return arr;
    }

    public JSONArray allCommunities(int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "community/list/all.json", new PostParameter[]{new PostParameter("page", page), new PostParameter("count", count)}, true);
        JSONArray arr = res.asJSONArray();
        return arr;
    }

    public Response getCommunityById(String id) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "community/info.json", new PostParameter[]{new PostParameter("community_id", id)}, true);
        return res;
    }

    public Response getMembers(String headChar, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "addressbook/member_list_simple.json", new PostParameter[]{new PostParameter("headChar", headChar), new PostParameter("page", page), new PostParameter("count", count)}, true);
        return res;
    }

    public Response getRecentlyContact(int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "addressbook/recently_contact_simple.json", new PostParameter[]{new PostParameter("page", page), new PostParameter("count", count)}, true);
        return res;
    }

    public Response searchContact(String q, int page, int count) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "addressbook/search_simple.json", new PostParameter[]{new PostParameter("page", page), new PostParameter("count", count), new PostParameter("q", q)}, true);
        return res;
    }

    public Response getAddressBookByUserId(String userId) throws WeiboException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "addressbook/" + userId + ".json", null, true);
        return res;
    }

    public Response addUserToCommunity2(String community_id, String email) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "community/add_user.json", new PostParameter[]{new PostParameter("community_id", community_id), new PostParameter("email", email)}, true);
        return res;
    }

    public Response delUserToCommunity2(String community_id, String email) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "community/remove_user.json", new PostParameter[]{new PostParameter("community_id", community_id), new PostParameter("email", email)}, true);
        return res;
    }

    public Response createCommunity(String name, String desc, boolean only_admin_invite) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "community/create.json", new PostParameter[]{new PostParameter("name", name), new PostParameter("desc", desc), new PostParameter("only_admin_invite", only_admin_invite ? "true" : "false")}, true);
        return res;
    }

    public boolean awardedAppAccessNetworkAuth(String appKey) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "app/awarded_app_access_network_auth.json", new PostParameter[]{new PostParameter("appKey", appKey)}, true);
        return res.getStatusCode() == 200;
    }

    public Status createLike(String id) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "like/create.json", new PostParameter[]{new PostParameter("id", id)}, true);
        return new Status(res);
    }

    public Status removeLike(String id) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "like/destory/" + id + ".json", new PostParameter[]{new PostParameter("id", id)}, true);
        return new Status(res);
    }

    public String addAccount(String email, String name, String realName, String company, String department, String mobile, String password, String communityId, String recomUserEmail, boolean dayDigest, boolean weekDigest, boolean existToken, boolean existUpdate, String sourceType, String source) throws WeiboException {
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "admin/account-spadd.json", new PostParameter[]{new PostParameter("email", email), new PostParameter("name", name), new PostParameter("realName", realName), new PostParameter("company", company), new PostParameter("department", department), new PostParameter("mobile", mobile), new PostParameter("password", password), new PostParameter("communityId", communityId), new PostParameter("recomUserEmail", recomUserEmail), new PostParameter("dayDigest", dayDigest ? "true" : "false"), new PostParameter("weekDigest", weekDigest ? "true" : "false"), new PostParameter("existToken", existToken ? "true" : "false"), new PostParameter("existUpdate", existUpdate ? "true" : "false"), new PostParameter("sourceType", sourceType), new PostParameter("source", source)}, true);
        JSONObject json = res.asJSONObject();
        try {
            if ("true".equals(json.getString("success"))) {
                String token = json.getString("login_token");
                return token;
            }
            throw new WeiboException("error:" + json.toString());
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public String hasFollowedTrend(String title) throws WeiboException {
        HashSet<PostParameter> parameters = new HashSet<PostParameter>();
        parameters.add(new PostParameter("trend", title));
        Response res = this.get(String.valueOf(this.getBaseURL()) + "trends/has_followed.json", parameters.toArray(new PostParameter[0]), true);
        return res.asString();
    }

    public JSONObject createAppMessageGroup(String channel, String groupName, String domain) throws WeiboException {
        String uri = String.valueOf(domain) + "/appMessage/create-group.json";
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + uri, new PostParameter[]{new PostParameter("groupName", groupName), new PostParameter("channel", channel)}, true);
        return res.asJSONObject();
    }

    public JSONObject updateAppMessageChannelStatus(String appMessageId, String channelStatus, String actId, String domain) throws WeiboException {
        String uri = String.valueOf(domain) + "/appMessage/updateChannelStatus/" + appMessageId + ".json";
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + uri, new PostParameter[]{new PostParameter("channelStatus", channelStatus), new PostParameter("actId", actId)}, true);
        return res.asJSONObject();
    }

    public JSONObject pushAppMessage(String appMessageXML, String domain) throws WeiboException {
        String uri = String.valueOf(domain) + "/appMessage/push.json";
        Response res = this.http.postXMLdata(String.valueOf(this.getBaseURL()) + uri, appMessageXML, new PostParameter[0], true);
        return res.asJSONObject();
    }

    public JSONObject resetAppMessageActions(String appMessageActionsXml, String appMessageId, String domain) throws WeiboException {
        String uri = String.valueOf(domain) + "/appMessage/resetActions/" + appMessageId + ".json";
        Response res = this.http.postXMLdata(String.valueOf(this.getBaseURL()) + uri, appMessageActionsXml, new PostParameter[0], true);
        return res.asJSONObject();
    }

    public JSONObject resetAppMessageStatusBar(String appMessageStatusBarXml, String appMessageId, String domain) throws WeiboException {
        String uri = String.valueOf(domain) + "/appMessage/resetStatusBars/" + appMessageId + ".json";
        Response res = this.http.postXMLdata(String.valueOf(this.getBaseURL()) + uri, appMessageStatusBarXml, new PostParameter[0], true);
        return res.asJSONObject();
    }

    public String outputCompanyAttendance(String beginDate, String endDate) throws WeiboException {
        String result;
        HashSet<PostParameter> parameters = new HashSet<PostParameter>();
        parameters.add(new PostParameter("beginDate", beginDate));
        parameters.add(new PostParameter("endDate", endDate));
        try {
            Response res = this.get(String.valueOf(this.getBaseURL()) + "attendance/date/output/company.json", parameters.toArray(new PostParameter[0]), true);
            result = res.asString();
        }
        catch (Exception e) {
            throw new WeiboException("error:" + e.getMessage());
        }
        return result;
    }
}

