/*
 * Decompiled with CFR 0.152.
 */
package kdweibo4j.http;

import kdweibo4j.WeiboException;
import kdweibo4j.http.AccessToken;
import kdweibo4j.http.HttpClient;
import kdweibo4j.http.OAuthToken;
import kdweibo4j.http.Response;

public class RequestToken
extends OAuthToken {
    private HttpClient httpClient;
    private static final long serialVersionUID = -8214365845469757952L;

    RequestToken(Response res, HttpClient httpClient) throws WeiboException {
        super(res);
        this.httpClient = httpClient;
    }

    public RequestToken(String token, String tokenSecret) {
        super(token, tokenSecret);
    }

    public String getAuthorizationURL() {
        return String.valueOf(this.httpClient.getAuthorizationURL()) + "?oauth_token=" + this.getToken();
    }

    public String getAuthenticationURL() {
        return String.valueOf(this.httpClient.getAuthenticationRL()) + "?oauth_token=" + this.getToken();
    }

    public AccessToken getAccessToken(String pin) throws WeiboException {
        return this.httpClient.getOAuthAccessToken(this, pin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestToken that = (RequestToken)o;
        return !(this.httpClient != null ? !this.httpClient.equals(that.httpClient) : that.httpClient != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.httpClient != null ? this.httpClient.hashCode() : 0);
        return result;
    }
}

