/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.KBProperty;
import com.kingbase8.ssl.LibPQFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ObjectFactory;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws KSQLException {
        String socketFactoryClassName = KBProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return (SocketFactory)ObjectFactory.instantiate(socketFactoryClassName, info, true, KBProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new KSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws KSQLException {
        String classname = KBProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.kingbase8.ssl.jdbc4.LibPQFactory".equals(classname) || "com.kingbase8.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            return (SSLSocketFactory)ObjectFactory.instantiate(classname, info, true, KBProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new KSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

