/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.util.LOGGER;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.logging.Level;

public class VisibleBufferedInputStream
extends InputStream {
    private static final int MINIMUM_READ = 1024;
    private static final int STRING_SCAN_SPAN = 1024;
    private final InputStream wrapped;
    private byte[] buffer;
    private int index;
    private int endIndex;
    private String host;
    private boolean useDispatch;
    private int version;
    private int socketTimeout;

    public VisibleBufferedInputStream(InputStream in, int bufferSize, String host, boolean useDispatch, int version) {
        this.wrapped = in;
        this.buffer = new byte[bufferSize < 1024 ? 1024 : bufferSize];
        this.host = host;
        this.useDispatch = useDispatch;
        this.version = version;
    }

    @Override
    public int read() throws IOException {
        if (this.ensureBytes(1)) {
            return this.buffer[this.index++] & 0xFF;
        }
        return -1;
    }

    public int peek() throws IOException {
        if (this.ensureBytes(1)) {
            return this.buffer[this.index] & 0xFF;
        }
        return -1;
    }

    public byte readRaw() {
        return this.buffer[this.index++];
    }

    public boolean ensureBytes(int n) throws IOException {
        int required = n - this.endIndex + this.index;
        while (required > 0) {
            if (!this.readMore(required)) {
                return false;
            }
            required = n - this.endIndex + this.index;
        }
        return true;
    }

    private boolean readMore(int wanted) throws IOException {
        int canFit;
        if (this.endIndex == this.index) {
            this.index = 0;
            this.endIndex = 0;
        }
        if ((canFit = this.buffer.length - this.endIndex) < wanted) {
            if (this.index + canFit > wanted + 1024) {
                this.compact();
            } else {
                this.doubleBuffer();
            }
            canFit = this.buffer.length - this.endIndex;
        }
        int read = -1;
        int i = 0;
        int j = 0;
        while (true) {
            try {
                read = this.wrapped.read(this.buffer, this.endIndex, canFit);
            }
            catch (SocketTimeoutException e) {
                if (this.useDispatch && (ConnectionMangerV2.master_online_ip.equals(this.host) || ConnectionMangerV2.slave_online_ip.contains(this.host + ",")) && ConnectionMangerV2.connVersion.get(this.host) == this.version && (this.socketTimeout == 0 || ++i < this.socketTimeout)) {
                    if (++j % 5 != 0) continue;
                    LOGGER.log(Level.INFO, "Online host {0} has been waiting for {1} times, socketTimeout is {2}", this.host, j, this.socketTimeout);
                    continue;
                }
                throw e;
            }
            break;
        }
        if (read < 0) {
            return false;
        }
        this.endIndex += read;
        return true;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    private void doubleBuffer() {
        byte[] buf = new byte[this.buffer.length * 2];
        this.moveBufferTo(buf);
        this.buffer = buf;
    }

    private void compact() {
        this.moveBufferTo(this.buffer);
    }

    private void moveBufferTo(byte[] dest) {
        int size = this.endIndex - this.index;
        System.arraycopy(this.buffer, this.index, dest, 0, size);
        this.index = 0;
        this.endIndex = size;
    }

    @Override
    public int read(byte[] to, int off, int len) throws IOException {
        int r;
        if ((off | len | off + len | to.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int avail = this.endIndex - this.index;
        if (len - avail < 1024) {
            this.ensureBytes(len);
            avail = this.endIndex - this.index;
        }
        if (avail > 0) {
            if (len <= avail) {
                System.arraycopy(this.buffer, this.index, to, off, len);
                this.index += len;
                return len;
            }
            System.arraycopy(this.buffer, this.index, to, off, avail);
            len -= avail;
            off += avail;
        }
        int read = avail;
        this.index = 0;
        this.endIndex = 0;
        do {
            if ((r = this.wrapped.read(to, off, len)) <= 0) {
                return read == 0 ? r : read;
            }
            read += r;
            off += r;
        } while ((len -= r) > 0);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        int avail = this.endIndex - this.index;
        if ((long)avail >= n) {
            this.index = (int)((long)this.index + n);
            return n;
        }
        this.index = 0;
        this.endIndex = 0;
        return (long)avail + this.wrapped.skip(n -= (long)avail);
    }

    @Override
    public int available() throws IOException {
        int avail = this.endIndex - this.index;
        return avail > 0 ? avail : this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getIndex() {
        return this.index;
    }

    public int scanCStringLength() throws IOException {
        int pos = this.index;
        while (true) {
            if (pos < this.endIndex) {
                if (this.buffer[pos++] != 0) continue;
                return pos - this.index;
            }
            if (!this.readMore(1024)) {
                throw new EOFException();
            }
            pos = this.index;
        }
    }
}

