/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import java.sql.SQLException;

public class ToJdbcShortTransformer
extends AbstractToJdbcTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return (short)0;
        }
        if (Number.class.isInstance(o)) {
            return ((Number)o).shortValue();
        }
        if (o instanceof byte[]) {
            try {
                return Short.parseShort(ToJdbcShortTransformer.encodeBytes((byte[])o, charset));
            }
            catch (NumberFormatException e) {
                String errorMsg = ToJdbcShortTransformer.getTransformationErrMsg(ToJdbcShortTransformer.encodeBytes((byte[])o, charset), Short.TYPE);
                throw new SQLException(errorMsg);
            }
        }
        String errorMsg = ToJdbcShortTransformer.getInvalidTransformationErrorMsg(o.getClass(), Short.TYPE);
        throw new SQLException(errorMsg);
    }
}

