/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SessionRecordSetIterator
implements Iterator<Record> {
    private static final long FETCH_COUNT = 1000L;
    private long actualFetchSize = 0L;
    private int idx = 0;
    private boolean finishIterRead = false;
    private TunnelRecordReader reader;
    private int cursor = 0;
    private List<Record> buffer;

    public SessionRecordSetIterator(TunnelRecordReader reader) {
        this.reader = reader;
    }

    public SessionRecordSetIterator(List<Record> buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            if (this.buffer == null) {
                return false;
            }
            return this.cursor < this.buffer.size();
        }
        if ((long)this.idx == this.actualFetchSize && this.finishIterRead) {
            return false;
        }
        if (this.buffer == null || (long)this.idx == this.actualFetchSize) {
            this.fillBuffer();
        }
        return (long)this.idx < this.actualFetchSize;
    }

    @Override
    public Record next() {
        if (this.reader == null) {
            return this.buffer.get(this.cursor++);
        }
        return this.buffer.get(this.idx++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private void fillBuffer() {
        this.idx = 0;
        this.actualFetchSize = 0L;
        this.buffer = new ArrayList<Record>();
        Record r = null;
        try {
            while (this.actualFetchSize < 1000L && (r = this.reader.read()) != null) {
                this.buffer.add(r);
                ++this.actualFetchSize;
            }
            if (this.actualFetchSize != 1000L) {
                this.finishIterRead = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Read result failed:" + e.getMessage(), e);
        }
    }
}

