/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FastWriter
extends Writer {
    protected static final Logger log = Logger.getLogger("facelets.util");
    private ByteArrayOutputStream out;
    private OutputStreamWriter writer;

    public FastWriter() {
        this(1024);
    }

    public FastWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Initial Size cannot be less than 0");
        }
        try {
            this.out = new ByteArrayOutputStream(initialSize);
            this.writer = new OutputStreamWriter((OutputStream)this.out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "Created ByteArrayOutputStream Error", e);
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        this.writer.flush();
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(int c) throws IOException {
        this.writer.write(c);
        this.writer.flush();
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    public void write(String str) throws IOException {
        this.write(str.toCharArray(), 0, str.length());
    }

    public void reset() {
        this.out.reset();
    }

    public String toString() {
        String s = "UnsupportedEncodingException";
        try {
            s = new String(this.out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "ToString Error for UnsupportedEncodingException", e);
        }
        return s;
    }
}

