/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.faces.FacesException;
import javax.faces.component.UIData;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.component.ajax.AjaxAction;

class DataItemActionListener
implements ActionListener {
    private UIData data;
    private Method method;

    public DataItemActionListener(UIData data, Method method) {
        this.data = data;
        this.method = method;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        Object target = null;
        if (this.data.isRowAvailable()) {
            target = this.data.getRowData();
        }
        if (target != null || Modifier.isStatic(this.method.getModifiers())) {
            ModelBean bean = ModelBean.wrap((Object)target);
            Class<?>[] paramTypes = this.method.getParameterTypes();
            try {
                if (paramTypes.length == 0) {
                    bean.invoke(this.method, new Object[0]);
                } else if (paramTypes.length == 1) {
                    if (event.getComponent() instanceof AjaxAction) {
                        PhaseId phaseId = event.getPhaseId();
                        event = new ActionEvent(event.getComponent().getParent());
                        event.setPhaseId(phaseId);
                    }
                    bean.invoke(this.method, new Object[]{event});
                }
            }
            catch (AbortProcessingException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }
}

