/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.context.FacesContext;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.faces.binding.impl.Injector;
import org.operamasks.faces.binding.impl.ScopeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELScopedStateBinding
extends Binding
implements Injector {
    protected String name;
    protected String scope;
    protected Closure closure;
    protected Closure init;

    public ELScopedStateBinding(String name, String scope, Closure closure, Closure init) {
        super(null);
        this.name = name;
        this.scope = scope;
        this.closure = closure;
        this.init = init;
    }

    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        Map<String, Object> scopeMap = this.getScopeMap(ctx, (ELiteBean)mbc.getModelBean());
        ELContext elctx = ctx.getELContext();
        if (scopeMap != null) {
            Object value = scopeMap.get(this.name);
            if (value != null) {
                this.closure.setValue(elctx, value);
            } else {
                if (this.init != null) {
                    value = this.init.call(elctx, new Object[0]);
                    this.closure.setValue(elctx, value);
                } else {
                    value = this.closure.getValue(elctx);
                }
                if (value != null) {
                    scopeMap.put(this.name, value);
                }
            }
        }
    }

    public void inject(FacesContext ctx, ModelBean bean) {
    }

    public void outject(FacesContext ctx, ModelBean bean) {
        Map<String, Object> scopeMap = this.getScopeMap(ctx, (ELiteBean)bean);
        ELContext elctx = ctx.getELContext();
        if (scopeMap != null) {
            Object value = this.closure.getValue(elctx);
            if (value != null) {
                scopeMap.put(this.name, value);
            } else {
                scopeMap.remove(this.name);
            }
        }
    }

    private Map<String, Object> getScopeMap(FacesContext ctx, ELiteBean bean) {
        String path = bean.getPath();
        if (path == null) {
            path = ctx.getViewRoot().getViewId();
        }
        ScopeManager scopeMgr = ScopeManager.getInstance();
        if ("session".equals(this.scope)) {
            return scopeMgr.getSessionMap(ctx, path);
        }
        if ("application".equals(this.scope)) {
            return scopeMgr.getApplicationMap(ctx, path);
        }
        if ("request".equals(this.scope)) {
            return scopeMgr.getRequestMap(ctx, path);
        }
        return null;
    }
}

