/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.ajax;

import org.operamasks.faces.component.ajax.ProgressAction;
import org.operamasks.faces.component.ajax.ProgressState;

public class ProgressStatus {
    private ProgressAction action;
    private ProgressState state;
    private int phase;
    private int percentage;
    private String message;

    public ProgressStatus(ProgressAction action) {
        this.action = action;
    }

    public ProgressAction getAction() {
        return this.action;
    }

    public ProgressState getState() {
        return this.state;
    }

    public void setState(ProgressState state) {
        this.state = state;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) {
        if (percentage < 0) {
            percentage = 0;
        } else if (percentage > 100) {
            percentage = 100;
        }
        this.percentage = percentage;
    }

    public void setPercentage(long numerator, long denominator) {
        if (numerator < 0L) {
            numerator = 0L;
        } else if (numerator > denominator) {
            numerator = denominator;
        }
        this.percentage = (int)(100L * numerator / denominator);
    }

    public void setPercentage(long lowBound, long highBound, long currentValue) {
        if (currentValue < lowBound) {
            currentValue = lowBound;
        } else if (currentValue >= highBound) {
            currentValue = highBound;
        }
        this.percentage = (int)((currentValue - lowBound) / (highBound - lowBound));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isStopped() {
        return this.state == ProgressState.STOPPED;
    }

    public boolean isPaused() {
        return this.state == ProgressState.PAUSED;
    }

    public boolean isCompleted() {
        return this.state == ProgressState.COMPLETED;
    }

    public boolean isFailed() {
        return this.state == ProgressState.FAILED;
    }

    public boolean isRunning() {
        return this.state == ProgressState.RUNNING;
    }
}

