/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.grid;

import java.io.Serializable;
import java.util.ArrayList;
import org.operamasks.faces.component.grid.GridColumn;

public class GridColumnModel
implements Serializable {
    private ArrayList<GridColumn> columns = new ArrayList();
    private boolean showRowNumber = true;

    public GridColumn[] getColumns() {
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public GridColumn getColumn(int colIndex) {
        return this.columns.get(colIndex);
    }

    public GridColumn getColumn(String colId) {
        return this.findColumnById(colId);
    }

    public int getColumnCount() {
        return this.getColumnCount(false);
    }

    public int getColumnCount(boolean includeHidden) {
        return includeHidden ? this.columns.size() : this.columns.size() - this.getHiddenColumn().length;
    }

    public GridColumn[] getHiddenColumn() {
        ArrayList<GridColumn> result = new ArrayList<GridColumn>();
        for (GridColumn c : this.columns) {
            if (!c.isHidden()) continue;
            result.add(c);
        }
        return result.toArray(new GridColumn[result.size()]);
    }

    public void addColumn(GridColumn column) {
        this.check(column);
        this.columns.add(column);
        this.columns.trimToSize();
    }

    public GridColumnModel columns(GridColumn ... columns) {
        for (GridColumn column : columns) {
            this.check(column);
            this.columns.add(column);
        }
        this.columns.trimToSize();
        return this;
    }

    public void addColumn(int colIndex, GridColumn column) {
        this.check(column);
        this.columns.add(colIndex, column);
        this.columns.trimToSize();
    }

    public GridColumn removeColumn(int colIndex) {
        GridColumn column = this.getColumn(colIndex);
        this.columns.remove(column);
        return column;
    }

    public GridColumn removeColumn(String colId) {
        GridColumn column = this.getColumn(colId);
        this.columns.remove(column);
        return column;
    }

    public GridColumn removeColumn(GridColumn column) {
        return this.columns.remove(column) ? column : null;
    }

    public GridColumn replaceColumn(GridColumn column) {
        GridColumn replaced = this.getColumn(column.getId());
        if (replaced != null) {
            int idx = this.columns.indexOf(replaced);
            this.columns.remove(idx);
            this.addColumn(idx, column);
        }
        return replaced;
    }

    public GridColumn replaceColumn(int colIndex, GridColumn column) {
        GridColumn replaced = this.columns.get(colIndex);
        this.columns.remove(colIndex);
        this.addColumn(colIndex, column);
        return replaced;
    }

    public GridColumn put(GridColumn column) {
        GridColumn replaced = this.getColumn(column.getId());
        if (replaced == null) {
            this.addColumn(column);
        } else {
            this.replaceColumn(column);
        }
        return replaced;
    }

    public String[] getColumnIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (GridColumn column : this.columns) {
            list.add(column.getId());
        }
        return list.toArray(new String[list.size()]);
    }

    public void reset() {
        this.columns.clear();
    }

    private GridColumn findColumnById(String colId) {
        if (colId == null) {
            return null;
        }
        for (GridColumn column : this.columns) {
            if (!colId.equals(column.getId())) continue;
            return column;
        }
        return null;
    }

    private void check(GridColumn column) {
        if (column.getId() == null) {
            throw new IllegalArgumentException("column's id could not be null");
        }
        boolean invalid = false;
        for (GridColumn c : this.columns) {
            if (!c.getId().equals(column.getId())) continue;
            invalid = true;
            break;
        }
        if (invalid) {
            throw new IllegalArgumentException("duplicate column id[" + column.getId() + "]");
        }
    }

    public boolean isShowRowNumber() {
        return this.showRowNumber;
    }

    public void setShowRowNumber(boolean showRowNumber) {
        this.showRowNumber = showRowNumber;
    }
}

