/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget.base;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.resource.SkinManager;

public abstract class UIChooseSkinBase
extends UIInput {
    public static final String COMPONENT_FAMILY = "org.operamasks.faces.widget.ChooseSkin";
    public static final String DEFAULT_RENDERER_TYPE = "javax.faces.Menu";
    public static final String MENU_RENDERER_TYPE = "org.operamasks.faces.widget.RadioMenuItem";
    protected String cookie;
    protected Integer cookieMaxAge;
    protected String accesskey;
    protected String dir;
    protected boolean disabled = false;
    protected String lang;
    protected String onblur;
    protected String onchange;
    protected String onclick;
    protected String onfocus;
    protected String onkeydown;
    protected String onkeypress;
    protected String onkeyup;
    protected String onmousedown;
    protected String onmousemove;
    protected String onmouseout;
    protected String onmouseover;
    protected String onmouseup;
    protected String style;
    protected String styleClass;
    protected String tabIndex;
    protected String title;

    public UIChooseSkinBase() {
        this.setRendererType(null);
    }

    public UIChooseSkinBase(UIComponent parent) {
        this();
        FacesUtils.createComponent((UIComponent)parent, (UIComponent)this);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getComponentType() {
        return "javax.faces.Input";
    }

    public String getRendererType() {
        String rendererType = super.getRendererType();
        if (rendererType != null) {
            return rendererType;
        }
        if (this.getParent() instanceof UIMenu) {
            return MENU_RENDERER_TYPE;
        }
        return DEFAULT_RENDERER_TYPE;
    }

    public Integer getCookieMaxAge() {
        if (this.cookieMaxAge != null) {
            return this.cookieMaxAge;
        }
        ValueExpression ve = this.getValueExpression("cookieMaxAge");
        if (ve != null) {
            return (Integer)ve.getValue(this.getFacesContext().getELContext());
        }
        return 2592000;
    }

    public abstract void setCookieMaxAge(Integer var1);

    public Object getValue() {
        Object value = super.getValue();
        if (value == null) {
            ExternalContext ectx;
            Cookie c;
            FacesContext context = this.getFacesContext();
            String cookie = this.getCookie();
            if (cookie != null && (c = (Cookie)(ectx = context.getExternalContext()).getRequestCookieMap().get(cookie)) != null) {
                value = c.getValue();
            }
            if (value == null) {
                value = SkinManager.getCurrentSkin((FacesContext)context);
            }
        }
        return value;
    }

    public abstract String getCookie();

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        String skin = (String)super.getValue();
        if (skin != null && skin.length() != 0) {
            ExternalContext ectx;
            String cookie = this.getCookie();
            if (cookie != null && (ectx = context.getExternalContext()).getResponse() instanceof HttpServletResponse) {
                HttpServletResponse response = (HttpServletResponse)ectx.getResponse();
                Cookie c = new Cookie(cookie, skin);
                c.setMaxAge(this.getCookieMaxAge().intValue());
                response.addCookie(c);
            }
            SkinManager.setCurrentSkin((FacesContext)context, (String)skin);
        }
    }

    public void queueEvent(FacesEvent event) {
        PartialUpdateCandidates.addForValueChange((UIInput)this);
        super.queueEvent(event);
    }
}

