/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget.menu.base;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.widget.UISeparator;
import org.operamasks.faces.component.widget.menu.UICheckMenuItem;
import org.operamasks.faces.component.widget.menu.UICommandMenuItem;
import org.operamasks.faces.component.widget.menu.UILinkMenuItem;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.component.widget.menu.UIRadioMenuItem;
import org.operamasks.faces.component.widget.menu.UITextMenuItem;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.event.MenuActionEvent;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;

public abstract class UIMenuBase
extends UICommand {
    public static final String COMPONENT_FAMILY = "org.operamasks.faces.widget.Menu";
    public static final String COMPONENT_TYPE = "org.operamasks.faces.widget.Menu";
    public static final String RENDERER_TYPE = "org.operamasks.faces.widget.Menu";
    private static final Class<?>[] MENUITEM_TYPES = new Class[]{UICommandMenuItem.class, UILinkMenuItem.class, UITextMenuItem.class, UICheckMenuItem.class, UIRadioMenuItem.class, UISeparator.class};
    protected String jsvar;
    protected String label;
    protected String image;
    protected Boolean disabled;
    protected String style;
    protected String styleClass;
    protected String disabledClass;
    protected String activeClass;
    protected String triggerJsvar;
    protected MethodExpression menuAction;

    public String getFamily() {
        return "org.operamasks.faces.widget.Menu";
    }

    public abstract MethodExpression getMenuAction();

    public void queueEvent(FacesEvent event) {
        boolean immediateBak = this.isImmediate();
        if (event.getSource() instanceof ActionSource) {
            ActionSource source = (ActionSource)event.getSource();
            this.setImmediate(source.isImmediate());
        }
        if (this.getMenuAction() != null) {
            MenuActionEvent menuEvent = null;
            if (event instanceof MenuActionEvent) {
                UIComponent item = ((MenuActionEvent)event).getItemComponent();
                menuEvent = new MenuActionEvent((UIComponent)this, item);
            } else if (event instanceof ActionEvent) {
                menuEvent = new MenuActionEvent((UIComponent)this, event.getComponent());
            }
            if (menuEvent != null) {
                super.queueEvent(menuEvent);
            }
        } else {
            super.queueEvent(event);
        }
        this.setImmediate(immediateBak);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof MenuActionEvent) {
            MenuActionEvent menuEvent = (MenuActionEvent)event;
            this.invokeAction(menuEvent);
        } else {
            super.broadcast(event);
        }
    }

    private void invokeAction(MenuActionEvent menuEvent) {
        MethodExpression action = this.getMenuAction();
        if (action != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            UIComponent item = menuEvent.getItemComponent();
            String fromAction = action.getExpressionString();
            String outcome = null;
            try {
                Object result = action.invoke(context.getELContext(), new Object[]{item});
                if (result != null) {
                    outcome = result.toString();
                }
            }
            catch (ELException ex) {
                throw new FacesException(action.getExpressionString() + ": " + ex.getMessage(), (Throwable)ex);
            }
            if (outcome != null) {
                NavigationHandler nh = context.getApplication().getNavigationHandler();
                nh.handleNavigation(context, fromAction, outcome);
                context.renderResponse();
            }
        }
    }

    public void addMenu(UIMenu menu) {
        this.addMenu(-1, menu);
    }

    public void addMenu(int index, UIMenu menu) {
        if (menu == null) {
            throw new NullPointerException("the menu to be added is null");
        }
        menu.getAttributes().put("isNew", Boolean.TRUE);
        if (index < 0) {
            this.getChildren().add(menu);
        } else {
            this.getChildren().add(index, menu);
        }
    }

    public void addMenuItem(UIComponent item) {
        this.addMenuItem(-1, item);
    }

    public void addMenuItem(int index, UIComponent item) {
        this.validateMenuItem(item);
        if (index < 0) {
            this.getChildren().add(item);
        } else {
            this.getChildren().add(index, item);
        }
    }

    public void removeMenu(UIMenu menu) {
        this.getChildren().remove((Object)menu);
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.getAttributes().put("jsvar", FacesUtils.getJsvar((FacesContext)context, (UIComponent)this));
        cm.getAttributes().put("itemVar", FacesUtils.getJsvar((FacesContext)context, (UIComponent)menu) + "_item");
        cm.invoke(context, "removeMenu", (UIComponent)this);
    }

    public void removeMenuItem(UIComponent item) {
        this.validateMenuItem(item);
        this.getChildren().remove(item);
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.getAttributes().put("jsvar", FacesUtils.getJsvar((FacesContext)context, (UIComponent)this));
        cm.getAttributes().put("itemVar", FacesUtils.getJsvar((FacesContext)context, (UIComponent)item));
        cm.invoke(context, "removeMenuItem", (UIComponent)this);
    }

    public void removeAll() {
        if (this.getChildCount() > 0) {
            this.getChildren().clear();
            FacesContext context = FacesContext.getCurrentInstance();
            ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
            cm.getAttributes().put("jsvar", FacesUtils.getJsvar((FacesContext)context, (UIComponent)this));
            cm.invoke(context, "removeAll", (UIComponent)this);
        }
    }

    private void validateMenuItem(UIComponent item) {
        if (item == null) {
            throw new NullPointerException("the menuItem to be added is null");
        }
        boolean valid = false;
        Class<?> itemClass = item.getClass();
        for (Class<?> clz : MENUITEM_TYPES) {
            if (!itemClass.isAssignableFrom(clz)) continue;
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("the menuItem's type is invlid");
        }
    }
}

