/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.widget.page;

import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ScalarDataModel;
import org.operamasks.faces.component.widget.page.PagedDataModel;
import org.operamasks.faces.component.widget.page.PagedDataProvider;

public class UIPagedData
extends UIData {
    private DataModel model;
    private String indexVar;

    protected void setDataModel(DataModel dataModel) {
        Object scalar;
        if (dataModel instanceof ScalarDataModel && (scalar = dataModel.getWrappedData()) instanceof PagedDataProvider) {
            dataModel = new PagedDataModel((PagedDataProvider)scalar);
        }
        if (dataModel instanceof PagedDataModel) {
            PagedDataModel paged = (PagedDataModel)dataModel;
            paged.setStart(super.getFirst());
            paged.setLimit(super.getRows());
        }
        super.setDataModel(dataModel);
        this.model = dataModel;
    }

    protected DataModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        Object current = this.getValue();
        if (current instanceof PagedDataProvider) {
            this.setDataModel(new PagedDataModel((PagedDataProvider)current));
            return this.model;
        }
        return super.getDataModel();
    }

    public void setFirst(int first) {
        super.setFirst(first);
        if (this.model instanceof PagedDataModel) {
            ((PagedDataModel)this.model).setStart(first);
        }
    }

    public void setRows(int rows) {
        super.setRows(rows);
        if (this.model instanceof PagedDataModel) {
            ((PagedDataModel)this.model).setLimit(rows);
        }
    }

    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        if (this.indexVar != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (this.model.isRowAvailable()) {
                requestMap.put(this.indexVar, rowIndex);
            } else {
                requestMap.remove(this.indexVar);
            }
        }
    }

    public String getIndexVar() {
        if (this.indexVar != null) {
            return this.indexVar;
        }
        ValueExpression ve = this.getValueExpression("indexVar");
        if (ve != null) {
            return (String)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setIndexVar(String indexVar) {
        this.indexVar = indexVar;
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.indexVar};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        int i = 0;
        super.restoreState(context, values[i++]);
        this.indexVar = (String)values[i++];
    }
}

