/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.event.ajax;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import org.operamasks.faces.application.impl.ActionListenerImpl;
import org.operamasks.faces.event.ajax.AjaxActionEvent;
import org.operamasks.faces.event.ajax.AjaxActionListener;

public class AjaxActionListenerAdapter
extends ActionListenerImpl
implements StateHolder {
    private AjaxActionListener listener;
    private String eventName;
    private boolean transientFlag = false;

    public AjaxActionListenerAdapter() {
    }

    public AjaxActionListenerAdapter(String eventName, AjaxActionListener listener) {
        this.listener = listener;
        this.eventName = eventName;
    }

    public boolean acceptEvent(String eventName) {
        return eventName != null && eventName.equals(this.eventName);
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        if (event instanceof AjaxActionEvent) {
            this.listener.processAjaxAction((AjaxActionEvent)event);
        } else {
            super.processAction(event);
        }
    }

    public AjaxActionListener getAjaxActionListener() {
        return this.listener;
    }

    public AjaxActionListener getListener() {
        return this.listener;
    }

    public void setListener(AjaxActionListener listener) {
        this.listener = listener;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void restoreState(FacesContext context, Object state) {
        this.eventName = (String)((Object[])state)[0];
        StateHolderSaver saver = (StateHolderSaver)((Object[])state)[1];
        this.listener = (AjaxActionListener)saver.restore(context);
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.eventName, new StateHolderSaver(context, this.listener)};
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    static class StateHolderSaver
    implements Serializable {
        private static final long serialVersionUID = 6470180891722042701L;
        private String className = null;
        private Serializable savedState = null;

        public StateHolderSaver(FacesContext context, Object toSave) {
            this.className = toSave.getClass().getName();
            if (toSave instanceof StateHolder) {
                if (!((StateHolder)toSave).isTransient()) {
                    this.savedState = (Serializable)((StateHolder)toSave).saveState(context);
                } else {
                    this.className = null;
                }
            } else if (toSave instanceof Serializable) {
                this.savedState = (Serializable)toSave;
                this.className = null;
            }
        }

        public Object restore(FacesContext context) throws IllegalStateException {
            Class toRestoreClass;
            Object result = null;
            if (null == this.className && null != this.savedState) {
                return this.savedState;
            }
            if (this.className == null) {
                return null;
            }
            try {
                toRestoreClass = StateHolderSaver.loadClass(this.className, this);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (null != toRestoreClass) {
                try {
                    result = toRestoreClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                catch (IllegalAccessException a) {
                    throw new IllegalStateException(a.getMessage());
                }
            }
            if (null != result && null != this.savedState && result instanceof StateHolder) {
                ((StateHolder)result).restoreState(context, (Object)this.savedState);
            }
            return result;
        }

        private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = fallbackClass.getClass().getClassLoader();
            }
            return Class.forName(name, false, loader);
        }
    }
}

